/***************************************************************************
							 Log.h
                             -------------------
    begin                : Thu April 17, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _LOG_H_
#define _LOG_H_

#include <stdio.h>

// messages defined as LVL_HIGH will be shown in most
// runs.  These are important messages.  
const int LVL_LOW	= 100;
const int LVL_MED	= 50;
const int LVL_HIGH	= 10;
const int LVL_NONE	= 0;

// CLog
// My logging class.  Nothing fancy, but will spit all the
// internal logging info to a file.
class CLog
{
public:
	CLog( int Level );
	~CLog();
	void	SetLevel( int NewLevel ){ m_Level = NewLevel; }
	void	Log( int Level, char *Format, ... );
	void	Flush();
protected:
	int		m_Level;
	FILE	*m_pFile;
};

#endif

