/***************************************************************************
								     KlassModelerView.h
                             -------------------
    begin                : Thu April 3, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _KLASSMODELERVIEW_H_
#define _KLASSMODELERVIEW_H_

#include "CodeObjects.h"
#include <wx/docview.h>

#define KM_PRINT			105
#define KM_LGENERATE_CODE	106
#define KM_LGENERATE_HTML	107

#define CONTENTS_WIDTH		8000
#define CONTENTS_HEIGHT		8000

class CModelCanvas;
class CKlassModelerDoc;
class CMainFrame;

class CKlassModelerView : public wxView
{
	DECLARE_DYNAMIC_CLASS(CKlassModelerView)
	DECLARE_EVENT_TABLE()
public:
	CKlassModelerView();
	virtual 				~CKlassModelerView();
	virtual bool			OnCreate( wxDocument *pDoc, long Flags );
	virtual void			OnDraw( wxDC *pDC );
	virtual void			OnUpdate( wxView *pSenser, wxObject *pHint=NULL );
	virtual bool			OnClose( bool bDeleteWindow=true );
	virtual void			OnActivate( wxActivateEvent &Event );
	CKlassModelerDoc		*GetDoc(){ return m_pDoc; }
	CModelCanvas			*GetCanvas(){ return m_pCanvas; }
	virtual void			OnPrint( wxCommandEvent &Event );
	virtual void			OnViewGrid( wxCommandEvent &Event );
	virtual void			OnGenerateCode( wxCommandEvent &Event );
	virtual void			OnGenerateHTML( wxCommandEvent &Event );
protected:
	wxFrame					*m_pFrame;
	CKlassModelerDoc		*m_pDoc;
	CModelCanvas			*m_pCanvas;
};
	
#endif
