/***************************************************************************
									  KlassModelerDoc.h
                             -------------------
    begin                : Thu April 3, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _KLASSMODELERDOC_H_
#define _KLASSMODELERDOC_H_

#include "CodeObjects.h"
#include <wx/docview.h>
#include <string>

using namespace std;

typedef vector<string>	StringVector;

class CModelCanvas;

class CKlassModelerDoc : public wxDocument
{
	DECLARE_DYNAMIC_CLASS(CKlassModelerDoc)
public:
	CKlassModelerDoc();
	virtual 			~CKlassModelerDoc();
	wxInputStream 		&LoadObject( wxInputStream &Stream );
	wxOutputStream		&SaveObject( wxOutputStream &Stream );
	ClassVector			*GetClassVector(){ return &m_Classes; }
	void				AddClass( CClass *pClass );
	void				RemoveClass( CClass *pClass );
	virtual bool		OnNewDocument();
	virtual bool		OnOpenDocument( const wxString &FileName );
	bool				NewClassesFromHeader( string FileName, ClassVector &NewClasses );
	bool				NewClassesFromClipboard( ClassVector &NewClasses );
	CClass				*FindClassNamed( string Name );
	bool				GenerateCode();
	bool				GenerateCodeFor( CClass *pClass, bool bFullModel=false );
	bool				GenerateHTML( CModelCanvas *pCanvas );
	string				GetBasePath();
	StringVector		*GetTypes(){ return &m_Types; }
	void				AddNewType( string Type );
protected:
	bool				ReadClasses( wxInputStream &Stream );
	bool				ReadInheritence( wxInputStream &Stream );
	bool				ReadRelation( wxInputStream &Stream );
	string 				ReadString( wxInputStream &Stream );
	bool 				ReadMethods( wxInputStream &Stream, CClass *pParent );
	bool 				ReadVariables( wxInputStream &Stream, CClass *pParent );
	bool 				ReadVariables( wxInputStream &Stream, CMethod *pParent );
	bool 				ReadVariable( wxInputStream &Stream, CVariable *&pVar );
	bool				ReadEnums( wxInputStream &Stream, CClass *pParent );
	bool 				ReadEnum( wxInputStream &Stream, CEnum *&pEnum );
	bool				NewClassesFromString( char *pString, int Length, string FileName, ClassVector &NewClasses );
	bool				Preprocessor( char* pFile, int FileSize, string& CleanFile );
	bool				ReadClassNameAndInheritence( string& File, int& Pos, CClass* pClass );
	bool				CheckForAccessType( string& File, int& Pos, AccessType& Access, bool& IsQtSignal, bool& IsQtSlot, bool &IsAccessLine );
	bool				FindClass( string& File, int& Pos );
	bool				ReadToken( string& Src, string& Dest, int& Pos );
	bool				StripWhiteSpaces( string& Src, int& Pos );
	bool				FindWhiteSpaces( string& Src, int& Pos );
	bool				ReadVariableOrMethod( string& Src, int& Pos, AccessType Access, CClass& Class, bool bIsQtSignal, bool bIsQtSlot );
	bool				ReadVariable( string& Src, int& Pos, AccessType Access, CClass& Class );
	bool				ReadMethod( string& Src, int& Pos, AccessType Access, CClass& Class, bool bIsQtSignal, bool bIsQtSlot );
	bool				ReadEnum( string &Src, int &pos, AccessType Access, CClass &Class );
	bool				SaveClass( wxOutputStream &Stream, CClass *pClass );
	bool				SaveMethod( wxOutputStream &Stream, CMethod *pMethod );
	bool				SaveVariable( wxOutputStream &Stream, CVariable *pVariable );
	bool				SaveEnum( wxOutputStream &Stream, CEnum *pEnum );
	bool				SaveInheritence( wxOutputStream &Stream, string ChildName, CInheritence *pInheritence );
	bool				SaveRelation( wxOutputStream &Stream, string ParentName, CRelation *pRelation );
	bool				WriteNewHeader( FILE *pFile, CClass *pClass );
	bool				WriteClass( FILE *pFile, CClass *pClass );
	void				WriteMethod( FILE *pFile, CMethod *pMethod );
	bool				AlterExistingHeader( int fd, CClass *pClass, string FullPath );
	bool				ReadLine( int fd, string &StrLine );
	bool				GenerateHTMLFor( CClass *pClass );
	bool				WriteMethodHTML( FILE *pFile, CMethod *pMethod );
	bool				WriteVariableHTML( FILE *pFile, CVariable *pVariable );
	string				MangleForHTMLName( const string &Src );
	bool				CreateDirStructure( string FullPath );
	bool				DirectoryExists( string FullPath );
	ClassVector 		m_Classes;
	float 				m_DocVersion;
	StringVector		m_Types;
};
	
#endif
