/***************************************************************************
                             CodeObjectsDlg.cpp
                             -------------------
    begin                : Fri April 11, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "CodeObjectsDlg.h"
#include "CodeObjects.h"
#include "ObjectNotebook.h"
#include "Log.h"
#include "KlassModelerDoc.h"

extern CLog MasterLog;

BEGIN_EVENT_TABLE(CCodeObjectsDlg,wxDialog)
	EVT_BUTTON(wxID_OK,CCodeObjectsDlg::OKPressed)
END_EVENT_TABLE()

// CCodeObjectsDlg
CCodeObjectsDlg::CCodeObjectsDlg( wxWindow *pParent, wxString Title, CKlassModelerDoc *pDoc )
#ifdef __WXMSW__
	: wxDialog( pParent, -1, Title, wxDefaultPosition, wxSize( 378, 490 ) )
#else
	: wxDialog( pParent, -1, Title, wxDefaultPosition, wxSize( 378, 470 ) )
#endif
{
	m_pNotebook = NULL;
	m_pDoc = pDoc;
}

CCodeObjectsDlg::~CCodeObjectsDlg()
{
	if( m_pNotebook )
		m_pNotebook->Destroy();
}

void CCodeObjectsDlg::Setup()
{
	new wxButton( this, wxID_OK, wxT("Ok"), wxPoint(200, 425), wxSize(-1, -1) );
	new wxButton( this, wxID_CANCEL, wxT("Cancel"), wxPoint(100, 425), wxSize(-1, -1) );
	OnSetup();
}

void CCodeObjectsDlg::OKPressed( wxCommandEvent &Event )
{
	OnOK();
	wxDialog::OnOK( Event );
}

// CClassDlg
CClassDlg::CClassDlg( wxWindow *pParent, CKlassModelerDoc *pDoc, CClass *pClass )
	: CCodeObjectsDlg( pParent, _T("Class Information"), pDoc )
{
	m_pClass = pClass;
}

CClassDlg::~CClassDlg()
{
	m_pClass = NULL;
}

void CClassDlg::OnSetup()
{
	m_pClassName = new wxTextCtrl( this, -1, wxString((wxChar*)m_pClass->GetName().c_str()), wxPoint(8,10), wxSize(357,25) );
	m_pNotebook = new CObjectNotebook( this, m_pDoc, -1, wxPoint(5,42), wxSize(360,370) );
	m_pNotebook->BuildForClass( m_pClass );
}

void CClassDlg::OnOK()
{
	m_pClass->SetName( (const char*)m_pClassName->GetValue() );
	m_pNotebook->CloseUp();
}

void CClassDlg::OnMethodActivated( CMethod *pMethod )
{
	CMethod		TheCopy( *pMethod );
	CMethodDlg	MethodDlg( this, &TheCopy, m_pDoc );

	MethodDlg.Setup();
	if( MethodDlg.ShowModal() != wxID_OK )
		return;
	TheCopy.CopyTo( *pMethod );
	m_pNotebook->FillMethodList(0);
	// all the redraw and modify stuff is done by the
	// thing that called up the CClassDlg, so I don't
	// have to do anything about it here.
}

void CClassDlg::OnVariableActivated( CVariable *pVariable )
{
	CVariable		TheCopy( *pVariable );
	CVariableDlg	VariableDlg( this, &TheCopy, false, m_pDoc );

	VariableDlg.Setup();
	if( VariableDlg.ShowModal() != wxID_OK )
		return;
	TheCopy.CopyTo( *pVariable );
	m_pNotebook->FillVariableList(0);
}

// CMethodDlg
CMethodDlg::CMethodDlg( wxWindow *pParent, CMethod *pMethod, CKlassModelerDoc *pDoc )
	: CCodeObjectsDlg( pParent, _T("Method Information"), pDoc )
{
	m_pMethod = pMethod;
}

CMethodDlg::~CMethodDlg()
{
	m_pMethod = NULL;
}

void CMethodDlg::OnSetup()
{
	wxString				Choices[3] = { _T("Public"), _T("Protected"), _T("Private") };
	StringVector			*pTypes;
	StringVector::iterator	itVect;
	wxString				Empty[1];

	m_pMethodName = new wxTextCtrl( this, -1, wxString((wxChar*)m_pMethod->GetName().c_str()), wxPoint(8,10), wxSize(357,25) );
	new wxStaticText( this, -1, _T("Return type"), wxPoint(8,45) );
	m_pReturnType = new wxComboBox( this, -1, wxString((wxChar*)m_pMethod->GetReturnType().c_str()), wxPoint(70, 40), wxSize(295,25), 0, Empty, wxCB_DROPDOWN | wxCB_SORT );
	pTypes = m_pDoc->GetTypes();
	for( itVect=pTypes->begin(); itVect!=pTypes->end(); ++itVect )
		m_pReturnType->Append( wxString((wxChar*)itVect->c_str()) );
	m_pReturnType->SetValue( wxString((wxChar*)m_pMethod->GetReturnType().c_str()) );
	m_pAccessType = new wxRadioBox( this, -1, _T("Access"), wxPoint(5,65), wxSize(220, 40), 3, Choices, 1, wxRA_SPECIFY_ROWS );
	if( m_pMethod->GetAccess() == Public )
		m_pAccessType->SetSelection( 0 );
	else if( m_pMethod->GetAccess() == Protected )
		m_pAccessType->SetSelection( 1 );
	else if( m_pMethod->GetAccess() == Private )
		m_pAccessType->SetSelection( 2 );
	m_pPureVirtual = new wxCheckBox( this, -1, _T("Pure Virtual"), wxPoint(230,72) );
	m_pPureVirtual->SetValue( m_pMethod->IsPureVirtual() );
	m_pConst = new wxCheckBox( this, -1, _T("Const"), wxPoint(305,72) );
	m_pConst->SetValue( m_pMethod->IsConst() );
	m_pQtSignal = new wxCheckBox( this, -1, _T("Qt Signal"), wxPoint(230,92) );
	m_pQtSignal->SetValue( m_pMethod->IsQtSignal() );
	m_pQtSlot = new wxCheckBox( this, -1, _T("Qt Slot"), wxPoint(305,92) );
	m_pQtSlot->SetValue( m_pMethod->IsQtSlot() );
	m_pNotebook = new CObjectNotebook( this, m_pDoc, -1, wxPoint(5,112), wxSize(360,300) );
	m_pNotebook->BuildForMethod( m_pMethod );
}

void CMethodDlg::OnOK()
{
	m_pMethod->SetName( (const char*)m_pMethodName->GetValue() );
	m_pMethod->SetReturnType( (const char*)m_pReturnType->GetValue() );
	if( m_pAccessType->GetSelection() == 0 )
		m_pMethod->SetAccessType( Public );
	else if( m_pAccessType->GetSelection() == 1 )
		m_pMethod->SetAccessType( Protected );
	else if( m_pAccessType->GetSelection() == 2 )
		m_pMethod->SetAccessType( Private );
	m_pMethod->SetPureVirtual( m_pPureVirtual->GetValue() );
	m_pMethod->SetIsQtSignal( m_pQtSignal->GetValue() );
	m_pMethod->SetIsQtSlot( m_pQtSlot->GetValue() );
	m_pMethod->SetIsConst( m_pConst->GetValue() );
	m_pNotebook->CloseUp();
}

void CMethodDlg::OnVariableActivated( CVariable *pVariable )
{
	CVariable		TheCopy( *pVariable );
	CVariableDlg	VariableDlg( this, &TheCopy, true, m_pDoc );

	VariableDlg.Setup();
	if( VariableDlg.ShowModal() != wxID_OK )
		return;
	TheCopy.CopyTo( *pVariable );
	m_pNotebook->FillVariableList(0);
}

// CVariableDlg
CVariableDlg::CVariableDlg( wxWindow *pParent, CVariable *pVariable, bool bIsArg, CKlassModelerDoc *pDoc )
	: CCodeObjectsDlg( pParent, _T("Variable Information"), pDoc )
{
	m_pVariable = pVariable;
	m_bIsArg = bIsArg;
}

CVariableDlg::~CVariableDlg()
{
	m_pVariable = NULL;
}

void CVariableDlg::OnSetup()
{
	wxString				Choices[3] = { _T("Public"), _T("Protected"), _T("Private") };
	wxString				Empty[1];
	StringVector			*pTypes;
	StringVector::iterator	itVect;

	m_pName = new wxTextCtrl( this, -1, wxString((wxChar*)m_pVariable->GetName().c_str()), wxPoint(8,10), wxSize(357,25) );
	new wxStaticText( this, -1, _T("Type"), wxPoint(8,45) );
	m_pType = new wxComboBox( this, -1, wxString((wxChar*)m_pVariable->GetType().c_str()), wxPoint(50, 40), wxSize(315,25), 0, Empty, wxCB_DROPDOWN | wxCB_SORT );
	pTypes = m_pDoc->GetTypes();
	for( itVect=pTypes->begin(); itVect!=pTypes->end(); ++itVect )
		m_pType->Append( wxString((wxChar*)itVect->c_str()) );
	m_pType->SetValue( wxString((wxChar*)m_pVariable->GetType().c_str()) );
	if( m_bIsArg ){
		m_pNotebook = new CObjectNotebook( this, m_pDoc, -1, wxPoint(5,82), wxSize(360,330) );
	} else {
		m_pAccessType = new wxRadioBox( this, -1, _T("Access"), wxPoint(5,65), wxSize(220, 40), 3, Choices, 1, wxRA_SPECIFY_ROWS );
		if( m_pVariable->GetAccess() == Public )
			m_pAccessType->SetSelection( 0 );
		else if( m_pVariable->GetAccess() == Protected )
			m_pAccessType->SetSelection( 1 );
		else if( m_pVariable->GetAccess() == Private )
			m_pAccessType->SetSelection( 2 );
		m_pNotebook = new CObjectNotebook( this, m_pDoc, -1, wxPoint(5,112), wxSize(360,300) );
	}
	m_pNotebook->BuildForVariable( m_pVariable );
}

void CVariableDlg::OnOK()
{
	m_pVariable->SetName( (const char*)m_pName->GetValue() );
	m_pVariable->SetType( (const char*)m_pType->GetValue() );
	if( !m_bIsArg ){
		if( m_pAccessType->GetSelection() == 0 )
			m_pVariable->SetAccessType( Public );
		else if( m_pAccessType->GetSelection() == 1 )
			m_pVariable->SetAccessType( Protected );
		else if( m_pAccessType->GetSelection() == 2 )
			m_pVariable->SetAccessType( Private );
	}
	m_pNotebook->CloseUp();
}


