/***************************************************************************
                          CodeObjects.h  -  description
                             -------------------
    begin                : Wed Dec 5 2001
    copyright            : (C) 2001 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify  
   it under the terms of the GNU General Public License as published by  
   the Free Software Foundation; either version 2 of the License, or     
   (at your option) any later version.
 ***************************************************************************/
#ifndef _CODEOBJECTS_H_
#define _CODEOBJECTS_H_

#include <vector>
#include <string>
#include <wx/gdicmn.h>
#include <functional>

class CClass;
class CVariable;
class CMethod;
class CInheritence;
class CRelation;
class CEnum;

using namespace std;

typedef vector<CMethod*>			MethodVector;
typedef vector<CVariable*>			VariableVector;
typedef vector<CClass*>				ClassVector;
typedef vector<CInheritence*>		InheritenceVector;
typedef vector<CRelation*>			RelationVector;
typedef vector<CEnum*>				EnumVector;

enum AccessType { Private, Public, Protected };

class CKlassModelerDoc;

class CClass
{
public:
	CClass( CKlassModelerDoc &Doc );
	CClass( CClass &Copy );
	virtual 			~CClass();
	void				Delete();
	void				CopyTo( CClass &Dest );
	string 				GetName(){ return m_Name; }
	void 				SetName( string Name );
	void 				SetPosition( const wxPoint& Position );
	void 				SetPosition( float X, float Y ){ m_X = X; m_Y = Y; }
	wxPoint 			GetPosition();
	float 				GetX(){ return m_X; }
	float 				GetY(){ return m_Y; }
	void 				Translate( float x, float y ){ m_X+=x; m_Y+=y; }
	string 				GetDoc(){ return m_Doc; }
	void 				SetDoc( string Doc ){ m_Doc = Doc; }
	void 				SetHeaderFile( string Name ){ m_HeaderFile = Name; }
	string 				GetHeaderFile(){ return m_HeaderFile; }
	void 				SetHTMLFile( string Name ){ m_HTMLFile = Name; }
	string 				GetHTMLFile(){ return m_HTMLFile; }
	MethodVector		*GetMethods(){ return &m_Methods; }
	CMethod				*GetMethod( int Index );
	void 				AddMethod( CMethod* pNewMethod ){ m_Methods.push_back( pNewMethod ); }
	void 				DeleteMethod( int Index );
	void 				SwapMethods( int Index1, int Index2 );
	VariableVector		*GetVariables(){ return &m_Variables; }
	CVariable			*GetVariable( int Index );
	void 				AddVariable( CVariable* pNewVariable ){ m_Variables.push_back( pNewVariable ); }
	void 				DeleteVariable( int Index );
	void 				SwapVariables( int Index1, int Index2 );
	EnumVector			*GetEnums(){ return &m_Enums; }
	void				AddEnum( CEnum *p ){ m_Enums.push_back( p ); }
	void				DeleteEnum( int Index );
	CEnum				*GetEnum( int Index );
	void 				AddInheritence( CInheritence* pInheritence ){ m_Inheritence.push_back( pInheritence ); }
	void 				DeleteInheritence( int Index );
	void				AddRelation( CRelation *pRelation ){ m_Relation.push_back( pRelation ); }
	void				DeleteRelation( int Index );
	InheritenceVector	*GetInheritence(){ return &m_Inheritence; }
	RelationVector		*GetRelation(){ return &m_Relation; }
	CInheritence		*GetInheritence( int Index );
	bool 				IsQObject(){ return m_bIsQObject; }
	void 				SetIsQObject( bool IsQObject ){ m_bIsQObject = IsQObject; }
	void				ComputeRect( wxDC *pDC );
	void				GetRect( wxRect &BoundingRect );
	void				SetExcludeHeader( bool b ){ m_bExcludeHeader=b; }
	bool				GetExcludeHeader(){ return m_bExcludeHeader; }
	void				SetExcludeHTML( bool b ){ m_bExcludeHTML=b; }
	bool				GetExcludeHTML(){ return m_bExcludeHTML; }
protected:
	string 				m_Name;
	string 				m_Doc;
	string 				m_HeaderFile;
	string 				m_HTMLFile;
	float 				m_X;
	float 				m_Y;
	bool 				m_bIsQObject;
	bool				m_bExcludeHeader;
	bool				m_bExcludeHTML;
	MethodVector		m_Methods;
	VariableVector		m_Variables;
	EnumVector			m_Enums;
	InheritenceVector	m_Inheritence;
	RelationVector		m_Relation;
	wxRect				m_Rect;	
	CKlassModelerDoc	&m_KMDoc;
};

class CMethod
{
public:
	CMethod( CKlassModelerDoc &Doc  );
	CMethod( CMethod &Copy );
	virtual 			~CMethod();
	void				Delete();
	string 				GetName(){ return m_Name; }
	void 				SetName( string Name ){ m_Name = Name; }
	string 				GetReturnType(){ return m_ReturnType; }
	void 				SetReturnType( string RetType );
	string 				GetFullText();
	AccessType 			GetAccess(){ return m_Access; }
	void 				SetAccessType( AccessType Type ){ m_Access = Type; }
	string 				GetDoc(){ return m_Doc; }
	void 				SetDoc( string Doc ){ m_Doc = Doc; }
	VariableVector		*GetArgs(){ return &m_Args; }
	CVariable			*GetArg( int Index );
	void 				AddArg( CVariable* pNewArg ){ m_Args.push_back( pNewArg ); }
	void 				DeleteArg( int Index );
	void 				SwapArgs( int Index1, int Index2 );
	bool 				IsPureVirtual(){ return m_bPureVirtual; }
	void 				SetPureVirtual( bool b ){ m_bPureVirtual=b; }
	bool				IsConst(){ return m_bIsConst; }
	void				SetIsConst( bool b ){ m_bIsConst = b; }
	bool 				IsQtSignal(){ return m_bIsQtSignal; }
	void 				SetIsQtSignal( bool IsSignal ){ m_bIsQtSignal = IsSignal; }
	bool 				IsQtSlot(){ return m_bIsQtSlot; }
	void 				SetIsQtSlot( bool IsSlot ){ m_bIsQtSlot = IsSlot; }
	string 				GetInlineCode(){ return m_InlineCode; }
	void 				SetInlineCode( string Code );
	void				CopyTo( CMethod &Dest );
protected:
	VariableVector		m_Args;
	string 				m_Name;
	string 				m_ReturnType;
	string 				m_Doc;
	string 				m_InlineCode;
	AccessType 			m_Access;
	bool 				m_bPureVirtual;
	bool				m_bIsConst;
	bool 				m_bIsQtSignal;
	bool 				m_bIsQtSlot;
	CKlassModelerDoc	&m_KMDoc;
};

class CVariable
{
public:
	CVariable( CKlassModelerDoc &Doc );
	CVariable( CVariable &Copy );
	virtual 			~CVariable();
	string 				GetFullText();
	string 				GetDoc(){ return m_Doc; }
	void 				SetDoc( string Doc ){ m_Doc = Doc; }
	string 				GetName(){ return m_Name; }
	void 				SetName( string Name ){ m_Name = Name; }
	string 				GetType(){ return m_Type; }
	void 				SetType( string Type );
	AccessType 			GetAccess(){ return m_Access; }
	void 				SetAccessType( AccessType Type ){ m_Access = Type; }
	void				CopyTo( CVariable &Dest );
protected:
	string 				m_Name;
	string 				m_Type;
	string 				m_Doc;
	AccessType 			m_Access;
	CKlassModelerDoc	&m_KMDoc;
};

class CEnum
{
public:
	CEnum( CKlassModelerDoc &Doc );
	CEnum( CEnum &Copy );
	virtual ~CEnum(){}
	string				GetName(){ return m_Name; }
	void				SetName( string Name );
	AccessType 			GetAccess(){ return m_Access; }
	void 				SetAccessType( AccessType Type ){ m_Access = Type; }
	string				GetText(){ return m_FullText; }
	void				SetText( string T );
protected:
	string				m_Name;
	AccessType			m_Access;
	string				m_FullText;
	CKlassModelerDoc	&m_KMDoc;
};

class CInheritence
{
public:
	CInheritence();
	CInheritence( CInheritence &Copy );
	virtual 			~CInheritence();
	void 				SetParent( CClass* pParent );
	CClass				*GetParent(){ return m_pParent; }
	void 				SetParentName( string Name ){ m_ParentName = Name; }
	string 				GetParentName();
	void 				SetHorizontal( float h ){ m_Horizontal = h; }
	float 				GetHorizontal(){ return m_Horizontal; }
	void 				SetVisible( bool Visible ){ m_bVisible = Visible; }
	bool 				GetVisible(){ return m_bVisible; }
protected:
	CClass				*m_pParent;
	float 				m_Horizontal;
	bool 				m_bVisible;
	string				m_ParentName;
};

class CRelation
{
public:
	CRelation(){ m_pChild = NULL; }
	CRelation( CRelation &Copy );
	virtual ~CRelation(){}
	void				SetChild( CClass *p ){ m_pChild = p; }
	CClass				*GetChild(){ return m_pChild; }
	void				SetParentName( string s ){ m_ParentName = s; }
	void				SetHasA( bool b ){ m_bIsHasA = b; }
	bool				IsHasA(){ return m_bIsHasA; }
protected:
	CClass				*m_pChild;
	string				m_ParentName;
	bool				m_bIsHasA;	// if false then it's a UsesA
};

struct ClassVectorLess : public binary_function<CClass*, CClass*, bool> 
{
	bool operator()(CClass *x, CClass *y) 
	{
		return x->GetName() < y->GetName();
	}
};

#endif
