/* ======================================================================== */
/*  CRC32 -- Wrapper program around file_crc32() that calculates and shows  */
/*           CRC values for files.                                          */
/* ======================================================================== */

#include "config.h"
#include "file/file.h"
#include "misc/crc32.h"

int main(int argc, char *argv[])
{
    if (argc < 2)
    {
        printf("Usage: %s file [file [file [...]]]\n", argv[0]);
        exit(1);
    }

    while (0<--argc)
    {
        uint_32 crc = file_crc32(*++argv);
        printf("%.8X  %s\n", crc, *argv);
    }

    return 0;
}
