/*

IMASM Macro Precompiler

Copyright (C) 2003  Joe Fisher, Shiny Technologies, LLC
http://www.shinytechnologies.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef PARSER_H_INCLUDED
#define PARSER_H_INCLUDED

#include <string>
#include <fstream>

#include "llist.h"
#include "strfifo.h"

using namespace std;

int stricmp_(const char *str1, const char *str2);

enum
{
    mPAREN,
    mNOPAREN,
    mUNKNOWN
};

typedef struct _tag_symbol
{
    string sName;
    int iVal;
    int iSize;
} symbol;

typedef struct _tag_macro
{
    string sName;
    int iType;
    LList<string> argList;
    LList<string> codeList;
} macro;

class Parser
{
    public:
        Parser(StringFIFO *iFIFO, StringFIFO *oFIFO) :
            inputFIFO (iFIFO), 
            outputFIFO(oFIFO) { }

        ~Parser();

        int ParseSourceFile();
        int ParseUntilOutput();
        char *GetErrorStr() {return m_szError;}

        struct ParseError
        {
            string msg;
            ParseError(string &m) : msg(m) { }
        };


    private:
        StringFIFO *inputFIFO, *outputFIFO;

        void PutString(string &s, bool addNl = true, bool Ignore = false);
        void PutStringAsCmt(string &s, bool addNl = true, bool Ignore = false);

        int ParseLine(string &s);
        int ReadMacro(macro *pMacro, string &szLine);
        int ExpandMacro(macro *pMacro, string &sLine, string &sTargetString);
        int ThrowError(char *format, ...);
        int ThrowWarning(char *format, ...);
        int FindMacros(string &sLine, string &sOut);
        int StripReturn(string &s);
        int StripReturn(char *s);
        
        macro *GetMacroPtr(const char *macName);
        int GetMacroString(macro *pMacro, string &sLine, string &sOut);
        int GetMacroArgs(macro *pMacro, string &sMacro);
        int GetMacroArgs(string &sMacName, string &sMacro, LList<string> &argList, int iType);

        LList<string> m_lineList;
        LList<macro> m_macroList;
        char m_szError[MAX_PATH];
};

#endif

