#include "config.h"

/* ======================================================================== */
/*  USAGE            -- Just give usage info and exit.                      */
/* ======================================================================== */
void usage(void)
{
    jzp_printf(
                                                                            "\n"
"jzIntv v%d.%d"                                                             "\n"
"Copyright 2006, Joseph Zbiciak"                                            "\n"
"Portions copyright 2006:  Tim Lindner, John Tanner, Rick Reynolds"         "\n"
"                          Pedro Guiffuni, Joe Fisher, Frank Palazzolo"     "\n"
                                                                            "\n"
"Usage:"                                                                    "\n"
"    jzintv [flags] gamefile"                                               "\n"
                                                                            "\n"
"Specifying a game image:"                                                  "\n"
"    jzIntv supports most, if not all, known formats for Intellivision"     "\n"
"    game ROM images.  When invoking jzIntv, provide the full path to"      "\n"
"    the game-image file.  If you omit the file extension, jzIntv will"     "\n"
"    search for an appropriate file by trying the following extensions:"    "\n"
"    .rom, .bin, .int, and .itv.  The overall ROM search process is"        "\n"
"    somewhat involved.  See the jzIntv documentation for details."         "\n"
                                                                            "\n"
"    If the filename ends in .bin, .int, or .itv, or if jzIntv does not"    "\n"
"    recognize the file's extension, it will assume the file is in BIN+CFG" "\n"
"    format.  In that case, jzIntv will look for a matching .cfg file."     "\n"
                                                                            "\n"
"    Systems with case-sensitive file names (Linux, UNIX, etc.) need to"    "\n"
"    ensure the filename extensions are in lower-case.  On all systems,"    "\n"
"    jzIntv expects to receive file names with lower-case extensions."      "\n"
                                                                            "\n"
"ROM Image Flags:"                                                          "\n"
"    -e /path/to/exec.bin          Specifies path to the EXEC ROM image."   "\n"
"    --execimg=/path/to/exec.bin   By default, jzIntv looks in current dir.  \n"
                                                                            "\n"
"    -g /path/to/grom.bin          Specifies path to the GROM ROM image."   "\n"
"    --gromimg=/path/to/grom.bin   By default, jzIntv looks in current dir.  \n"
                                                                            "\n"
"    -E /path/to/ecs.bin           Specifies path to the ECS ROM image"     "\n"
"    --ecsimg=/path/to/ecs.bin     By default, jzIntv looks in current dir.  \n"
"                                  Only needed when ECS is enabled."        "\n"
                                                                            "\n"
"Intellivision Hardware Flags:"                                             "\n"
"    -s#     --ecs=#               ECS.           0: Disable, 1: Enable"    "\n"
"    -v#     --voice=#             Intellivoice.  0: Disable, 1: Enable"    "\n"
"    -W#     --voicewindow=#       Sets averaging window for voice filter." "\n"
"    -Vname  --voicefiles=name     Saves voice WAV files to name####.wav."  "\n"
                                                                            "\n"
"Video and Sound Flags:"                                                    "\n"
#ifndef GP2X
"    -z#     --displaysize=#       Desired display mode:"                   "\n"
"                                      0:  320x200x8bpp"                    "\n"
"                                      1:  640x480x8bpp"                    "\n"
"                                      2:  320x240x16bpp"                   "\n"
                                                                            "\n"
"    -f# -x# --fullscreen=#        Full screen display:"                    "\n"
"                                      0:  Windowed"                        "\n"
"                                      1:  Full screen"                     "\n"
#endif
                                                                            "\n"
"    -a#     --audiorate=#         Audio sampling rate.  0 disables audio." "\n"
"            --audio=#             Synonym for --audiorate."                "\n"
"    -Fname  --audiofile=name      Records all audio to specified file."    "\n"
"    -w#     --audiowindow=#       Sets averaging window for audio filter." "\n"
"    -B#     --audiobufsize=#      Internal audio buffer size."             "\n"
"    -C#     --audiobufcnt=#       Internal audio buffer count."            "\n"
"    -M#     --audiomintick=#      Minimum Intellivion cycles between"      "\n"
"                                  explicit calls to snd_tick()."           "\n"
                                                                            "\n"
"Input Configuration Flags:"                                                "\n"
"    Currently, jzIntv does not offer a flexible method to re-bind keys."   "\n"
"    The kbdhackfile does allow you to crudely specify key bindings."       "\n"
                                                                            "\n"
"    --kbdhackfile=/path/to/file   Configure key bindings."                 "\n"
                                                                            "\n"
"    Analog and USB joysticks have a rich set of configuration parameters." "\n"
"    Run jzIntv with an empty configuration string to find out defaults"    "\n"
"    are for your joystick and operating system.  For more information on"  "\n"
"    configuring joysticks, see the file jzintv/doc/jzintv/joystick.txt"    "\n"
                                                                            "\n"
"    --js0=\"config string\"       Configures Joystick #0"                  "\n"
"    --js1=\"config string\"       Configures Joystick #1"                  "\n"
"    --js2=\"config string\"       Configures Joystick #2"                  "\n"
"    --js3=\"config string\"       Configures Joystick #3"                  "\n"
                                                                            "\n"
#ifdef DIRECT_INTV2PC
"    The INTV2PC can drive either the Master Component or the ECS' controller\n"
"    inputs.  The following flags associate INTV2PCs with controllers:"     "\n"
                                                                            "\n"
"    -i#     --i2pc0=#             Port # for INTV2PC for Master Comp inputs.\n"
"    -I#     --i2pc1=#             Port # for INTV2PC for ECS inputs."      "\n"
"            --intv2pc0=#          Synonym for --i2pc0"                     "\n"
"            --intv2pc1=#          Synonym for --i2pc1"                     "\n"
                                                                            "\n"
#endif
#ifdef CGC_DLL
"    The Classic Game Controller can drive either the Master Component or"  "\n"
"    the ECS' controller inputs.  The following flags associate CGCs with"  "\n"
"    controllers:"                                                          "\n"
                                                                            "\n"
"    --cgc0[=#]                    CGC for Master Component inputs."        "\n"
"    --cgc1[=#]                    CGC for ECS inputs."                     "\n"
                                                                            "\n"
#endif
#ifdef CGC_THREAD
"    The Classic Game Controller can drive either the Master Component or"  "\n"
"    the ECS' controller inputs.  The following flags associate CGCs with"  "\n"
"    controllers.  They also specify the path to the CGC's device node:"    "\n"
                                                                            "\n"
"    --cgc0=/path/to/cgc           CGC for Master Component inputs."        "\n"
"    --cgc1=/path/to/cgc           CGC for ECS inputs."                     "\n"
                                                                            "\n"
#endif
"Intellicart .ROM emulation specific flags:"                                "\n"
"    -c#     --icartcache=#        Change caching policy for Intellicart"   "\n"
"                                  .ROM programs:"                          "\n"
"                                  0:  Cache bankswitched memory (default)" "\n"
"                                  1:  Don't cache bankswitched memory"     "\n"
"                                  2:  Only cache read-only, non-banksw."   "\n"
"                                  3:  Do not cache anything."              "\n"
                                                                            "\n"
"Misc Flags:"                                                               "\n"
"    -d#     --debugger=#          Enable jzIntv's debugger."               "\n"
                                                                            "\n"
"    -r#     --ratecontrol=#       Speed up by factor #."                   "\n"
"            --macho=#             Setting to 0 disables rate control."     "\n"
                                                                            "\n"
"    -P path --rom-path=path       Append path to the ROM search path."     "\n"
                                                                            "\n"
"    -q      --quiet               Hide jzIntv's non-error output."         "\n"
                                                                            "\n"
"            --gui-mode            Tells jzIntv to listen for commands from""\n"
"                                  a GUI over stdin."                       "\n"
                                                                            "\n"
"    -l      --license             License information"                     "\n"
" -h -?      --help                This usage info"                         "\n"
                                                                            "\n"
"Environment:"                                                              "\n"
"    JZINTV_ROM_PATH               Controls ROM search path.  Components of\n"
"                                  the ROM search path should be separated" "\n"
"                                  by \"" PATH_COMPONENT_SEP 
                                       "\" characters.  jzIntv examines"    "\n"
"                                  dirs specified by --rom-path before"     "\n"
"                                  dirs specified by JZINTV_ROM_PATH."      "\n"
                                                                            "\n"
#ifdef GP2X
"GP2X specific flags"                                                       "\n"
"            --gp2xclock=#         Set clock rate in MHz.  Default:  200MHz.\n"
"                                  0 means \"do not change current rate.\"" "\n"
                                                                            "\n"
"            --gp2x-pad-bias=#     Set the biasing mode for the GP2X's"     "\n"
"                                  directional control pad:"                "\n"
"                                  1: 16-dir, no bias (default)"            "\n"
"                                  2: 8-dir, UD/LR bias"                    "\n"
"                                  3: 8-dir, diagonal bias"                 "\n"
"                                  4: 8-dir with dead zones"                "\n"
"                                  5: 4-dir, UD/LR bias"                    "\n"
"                                  6: 4-dir, diagonal bias"                 "\n"
                                                                            "\n"
#endif
    ,JZINTV_VERSION_MAJOR
    ,JZINTV_VERSION_MINOR
    );

    exit(0);
}

/* ======================================================================== */
/*  LICENSE          -- Just give license/authorship info and exit.         */
/* ======================================================================== */
void license(void)
{
    jzp_printf(
                                                                            "\n"
    "jzIntv v%d.%d"                                                         "\n"
    "Copyright 2006, Joseph Zbiciak"                                        "\n"
    "Portions copyright 2006:  Tim Lindner, John Tanner, Rick Reynolds"     "\n"
    "                          Pedro Guiffuni, Joe Fisher, Frank Palazzolo" "\n"
                                                                            "\n"
    "This program is free software; you can redistribute it and/or modify"  "\n"
    "it under the terms of the GNU General Public License as published by"  "\n"
    "the Free Software Foundation; either version 2 of the License, or"     "\n"
    "(at your option) any later version."                                   "\n"
                                                                            "\n"
    "This program is distributed in the hope that it will be useful,"       "\n"
    "but WITHOUT ANY WARRANTY; without even the implied warranty of"        "\n"
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU"     "\n"
    "General Public License for more details."                              "\n"
                                                                            "\n"
    "You should have received a copy of the GNU General Public License"     "\n"
    "along with this program; if not, write to the Free Software"           "\n"
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."             "\n"
                                                                            "\n"
    "Run \"jzintv --help\" for usage information."                          "\n"
                                                                            "\n"
    ,JZINTV_VERSION_MAJOR
    ,JZINTV_VERSION_MINOR
    );

    exit(0);
}
