/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.JaroWinkler;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.TFIDF;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class SoftTFIDF
extends TFIDF {
    private StringDistance tokenDistance;
    private double tokenMatchThreshold;
    private static final StringDistance DEFAULT_TOKEN_DISTANCE = new JaroWinkler();

    public SoftTFIDF(Tokenizer tokenizer, StringDistance stringDistance, double d) {
        super(tokenizer);
        this.tokenDistance = stringDistance;
        this.tokenMatchThreshold = d;
    }

    public SoftTFIDF(StringDistance stringDistance, double d) {
        this.tokenDistance = stringDistance;
        this.tokenMatchThreshold = d;
    }

    public SoftTFIDF(StringDistance stringDistance) {
        this(stringDistance, 0.9);
    }

    public void setTokenMatchThreshold(double d) {
        this.tokenMatchThreshold = d;
    }

    public void setTokenMatchThreshold(Double d) {
        this.tokenMatchThreshold = d;
    }

    public double getTokenMatchThreshold() {
        return this.tokenMatchThreshold;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (bagOfTokens2.contains(token)) {
                d += bagOfTokens.getWeight(token) * bagOfTokens2.getWeight(token);
                continue;
            }
            double d2 = this.tokenMatchThreshold;
            Token token2 = null;
            Iterator iterator2 = bagOfTokens2.tokenIterator();
            while (iterator2.hasNext()) {
                Token token3 = (Token)iterator2.next();
                double d3 = this.tokenDistance.score(token.getValue(), token3.getValue());
                if (!(d3 >= d2)) continue;
                token2 = token3;
                d2 = d3;
            }
            if (token2 == null) continue;
            d += bagOfTokens.getWeight(token) * bagOfTokens2.getWeight(token2) * d2;
        }
        return d;
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        StringBuffer stringBuffer = new StringBuffer("");
        PrintfFormat printfFormat = new PrintfFormat("%.3f");
        stringBuffer.append("Common tokens: ");
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (bagOfTokens2.contains(token)) {
                stringBuffer.append(" " + token.getValue() + ": ");
                stringBuffer.append(printfFormat.sprintf(bagOfTokens.getWeight(token)));
                stringBuffer.append("*");
                stringBuffer.append(printfFormat.sprintf(bagOfTokens2.getWeight(token)));
                continue;
            }
            double d = this.tokenMatchThreshold;
            Token token2 = null;
            Iterator iterator2 = bagOfTokens2.tokenIterator();
            while (iterator2.hasNext()) {
                Token token3 = (Token)iterator2.next();
                double d2 = this.tokenDistance.score(token.getValue(), token3.getValue());
                if (!(d2 >= d)) continue;
                token2 = token3;
                d = d2;
            }
            if (token2 == null) continue;
            stringBuffer.append(" '" + token.getValue() + "'~='" + token2.getValue() + "': ");
            stringBuffer.append(printfFormat.sprintf(bagOfTokens.getWeight(token)));
            stringBuffer.append("*");
            stringBuffer.append(printfFormat.sprintf(bagOfTokens2.getWeight(token2)));
            stringBuffer.append("*");
            stringBuffer.append(printfFormat.sprintf(d));
        }
        stringBuffer.append("\nscore = " + this.score(stringWrapper, stringWrapper2));
        return stringBuffer.toString();
    }

    public String toString() {
        return "[SoftTFIDF thresh=" + this.tokenMatchThreshold + ";" + this.tokenDistance + "]";
    }
}

