/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.AffineGap;
import com.wcohen.secondstring.CharMatchScore;
import com.wcohen.secondstring.StringWrapper;
import java.util.HashSet;
import java.util.Set;

public class MongeElkan
extends AffineGap {
    private boolean scaling = true;
    private static final int CHAR_EXACT_MATCH_SCORE = 5;
    private static final int CHAR_APPROX_MATCH_SCORE = 3;
    private static final int CHAR_MISMATCH_MATCH_SCORE = -3;
    private static Set[] approx = new Set[7];
    private static final CharMatchScore MY_CHAR_MATCH_SCORE;

    public void setScaling(boolean bl) {
        this.scaling = bl;
    }

    public void setScaling(Double d) {
        this.scaling = d != 0.0;
    }

    public MongeElkan() {
        super(MY_CHAR_MATCH_SCORE, -5.0, -1.0, 0.0);
        this.setScaling(true);
    }

    public String toString() {
        return "[MongeElkan]";
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        if (this.scaling) {
            int n = Math.min(stringWrapper.unwrap().length(), stringWrapper2.unwrap().length());
            return super.score(stringWrapper, stringWrapper2) / (double)(n * 5);
        }
        return super.score(stringWrapper, stringWrapper2);
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        if (this.scaling) {
            int n = Math.min(stringWrapper.unwrap().length(), stringWrapper2.unwrap().length());
            double d = super.score(stringWrapper, stringWrapper2) / (double)(n * 5);
            return super.explainScore(stringWrapper, stringWrapper2) + "\nScaling factor: " + n * 5 + "\nScaled score: " + d;
        }
        return super.explainScore(stringWrapper, stringWrapper2);
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new MongeElkan(), stringArray);
    }

    static {
        MongeElkan.approx[0] = new HashSet();
        approx[0].add(new Character('d'));
        approx[0].add(new Character('t'));
        MongeElkan.approx[1] = new HashSet();
        approx[1].add(new Character('g'));
        approx[1].add(new Character('j'));
        MongeElkan.approx[2] = new HashSet();
        approx[2].add(new Character('l'));
        approx[2].add(new Character('r'));
        MongeElkan.approx[3] = new HashSet();
        approx[3].add(new Character('m'));
        approx[3].add(new Character('n'));
        MongeElkan.approx[4] = new HashSet();
        approx[4].add(new Character('b'));
        approx[4].add(new Character('p'));
        approx[4].add(new Character('v'));
        MongeElkan.approx[5] = new HashSet();
        approx[5].add(new Character('a'));
        approx[5].add(new Character('e'));
        approx[5].add(new Character('i'));
        approx[5].add(new Character('o'));
        approx[5].add(new Character('u'));
        MongeElkan.approx[6] = new HashSet();
        approx[6].add(new Character(','));
        approx[6].add(new Character('.'));
        MY_CHAR_MATCH_SCORE = new CharMatchScore(){

            public double matchScore(char c, char c2) {
                if ((c = Character.toLowerCase(c)) == (c2 = Character.toLowerCase(c2))) {
                    return 5.0;
                }
                Character c3 = new Character(c);
                Character c4 = new Character(c2);
                int n = 0;
                while (n < approx.length) {
                    if (approx[n].contains(c3) && approx[n].contains(c4)) {
                        return 3.0;
                    }
                    ++n;
                }
                return -3.0;
            }
        };
    }
}

