/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringWrapper;

public abstract class MemoMatrix {
    private double[][] value;
    private boolean[][] computed;
    protected StringWrapper s;
    protected StringWrapper t;
    protected String cellFormat = "%3g";
    private boolean printNegativeValues = false;

    MemoMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        this.s = stringWrapper;
        this.t = stringWrapper2;
        this.value = new double[stringWrapper.length() + 1][stringWrapper2.length() + 1];
        this.computed = new boolean[stringWrapper.length() + 1][stringWrapper2.length() + 1];
    }

    abstract double compute(int var1, int var2);

    final double get(int n, int n2) {
        if (!this.computed[n][n2]) {
            this.value[n][n2] = this.compute(n, n2);
            this.computed[n][n2] = true;
        }
        return this.value[n][n2];
    }

    protected final char sAt(int n) {
        return this.s.charAt(n - 1);
    }

    protected final char tAt(int n) {
        return this.t.charAt(n - 1);
    }

    final void setPrintNegativeValues(boolean bl) {
        this.printNegativeValues = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   ");
        int n = 1;
        while (n <= this.s.length()) {
            stringBuffer.append(" " + this.sAt(n) + " ");
            ++n;
        }
        stringBuffer.append("\n");
        stringBuffer.append("   ");
        int n2 = 1;
        while (n2 <= this.s.length()) {
            stringBuffer.append("---");
            ++n2;
        }
        stringBuffer.append("\n");
        PrintfFormat printfFormat = new PrintfFormat(this.cellFormat);
        int n3 = 1;
        while (n3 <= this.t.length()) {
            stringBuffer.append(" " + this.tAt(n3) + "|");
            int n4 = 1;
            while (n4 <= this.s.length()) {
                double d = this.printNegativeValues ? -this.get(n4, n3) : this.get(n4, n3);
                stringBuffer.append(printfFormat.sprintf(d));
                ++n4;
            }
            stringBuffer.append("\n");
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected static final double max3(double d, double d2, double d3) {
        return Math.max(d, Math.max(d2, d3));
    }

    protected static final double max4(double d, double d2, double d3, double d4) {
        return Math.max(Math.max(d, d2), Math.max(d3, d4));
    }
}

