/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.Token;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class BagOfTokens
extends StringWrapper {
    private Map weightMap = new TreeMap();
    private double totalWeight = 0.0;

    BagOfTokens(String string, Token[] tokenArray) {
        super(string);
        int n = 0;
        while (n < tokenArray.length) {
            this.weightMap.put(tokenArray[n], new Double(this.getWeight(tokenArray[n]) + 1.0));
            ++n;
        }
        this.totalWeight = tokenArray.length;
    }

    Iterator tokenIterator() {
        return this.weightMap.keySet().iterator();
    }

    boolean contains(Token token) {
        return this.weightMap.get(token) != null;
    }

    double getWeight(Token token) {
        Double d = (Double)this.weightMap.get(token);
        return d == null ? 0.0 : d;
    }

    void setWeight(Token token, double d) {
        Double d2 = (Double)this.weightMap.get(token);
        this.totalWeight += d2 == null ? d : d - d2;
        this.weightMap.put(token, new Double(d));
    }

    int size() {
        return this.weightMap.keySet().size();
    }

    double getTotalWeight() {
        return this.totalWeight;
    }
}

