/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.JXM.JXM;
import com.kfu.JXM.MainWindow;
import com.kfu.xm.ChannelInfo;
import com.kfu.xm.RadioCommander;
import com.wcohen.secondstring.JaroWinkler;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SearchSystem {
    private static final Pattern legal = Pattern.compile("^\\s*(\\d+|\\d+\\s*\\-\\s*\\d+)(\\s*,\\s*(\\d+|\\d+\\s*\\-\\s*\\d+))*\\s*$");
    private static final Pattern extract = Pattern.compile("((?:\\d+)(?:\\s*\\-\\s*\\d+)?)");
    private MainWindow parent;
    private JPanel searchConfig;
    private DefaultListModel searchList = new DefaultListModel();
    private JList configList;
    private JTextField channelEditor;
    private JTextField artistEditor;
    private JTextField titleEditor;
    private JButton deleteButton;
    private SearchMatcher searchBeingEdited;
    private boolean ignoreUpdates = false;
    private JDialog searchMatches;
    private DefaultListModel matches = new DefaultListModel();
    private JList matchList;
    private static final String SEARCH_LIST_KEY = "SearchItems";
    private static final StringDistance matchAlgorithm = new JaroWinkler();

    private double getWinningScore() {
        return this.parent.getSearchAccuracy();
    }

    private static int[] parseChannelList(String string) {
        int n;
        Object object;
        if (string.length() == 0) {
            return new int[0];
        }
        Matcher matcher = legal.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Channel list syntax error");
        }
        matcher = extract.matcher(string);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (matcher.find()) {
            int n2;
            object = matcher.group();
            n = ((String)object).indexOf(45);
            if (n >= 0) {
                int n3;
                n2 = Integer.parseInt(((String)object).substring(0, n));
                int n4 = Integer.parseInt(((String)object).substring(n + 1));
                if (n2 > 256 || n4 > 256) {
                    throw new IllegalArgumentException("Channel number way too big");
                }
                if (n2 > n4) {
                    n3 = n2;
                    n2 = n4;
                    n4 = n3;
                }
                for (n3 = n2; n3 <= n4; ++n3) {
                    arrayList.add(new Integer(n3));
                }
                continue;
            }
            n2 = Integer.parseInt((String)object);
            arrayList.add(new Integer(n2));
        }
        object = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            object[n] = (Integer)arrayList.get(n);
        }
        Arrays.sort((int[])object);
        return object;
    }

    public JComponent getPrefPanel() {
        return this.searchConfig;
    }

    public SearchSystem(MainWindow mainWindow) {
        this.parent = mainWindow;
        this.searchConfig = new JPanel();
        this.searchConfig.setLayout(new GridBagLayout());
        this.configList = new JList(this.searchList);
        class SearchConfigRenderer
        extends JPanel
        implements ListCellRenderer {
            JLabel chanLabel;
            JLabel artLabel;
            JLabel titLabel;
            JLabel chanName;
            JLabel artName;
            JLabel titName;

            public SearchConfigRenderer() {
                this.setOpaque(true);
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.chanName = new JLabel("Channels:");
                this.chanName.setHorizontalAlignment(11);
                gridBagConstraints.insets = new Insets(0, 10, 0, 10);
                gridBagConstraints.anchor = 22;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                this.add((Component)this.chanName, gridBagConstraints);
                this.artName = new JLabel("Artist:");
                this.artName.setHorizontalAlignment(11);
                gridBagConstraints.gridy = 1;
                this.add((Component)this.artName, gridBagConstraints);
                this.titName = new JLabel("Title:");
                this.titName.setHorizontalAlignment(11);
                gridBagConstraints.gridy = 2;
                this.add((Component)this.titName, gridBagConstraints);
                this.chanLabel = new JLabel();
                this.chanLabel.setHorizontalAlignment(10);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 21;
                this.add((Component)this.chanLabel, gridBagConstraints);
                this.artLabel = new JLabel();
                this.artLabel.setHorizontalAlignment(10);
                gridBagConstraints.gridy = 1;
                this.add((Component)this.artLabel, gridBagConstraints);
                this.titLabel = new JLabel();
                this.titLabel.setHorizontalAlignment(10);
                gridBagConstraints.gridy = 2;
                this.add((Component)this.titLabel, gridBagConstraints);
                this.validate();
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                SearchMatcher searchMatcher = (SearchMatcher)object;
                this.chanLabel.setText(searchMatcher.getChannels());
                this.artLabel.setText(searchMatcher.getArtist());
                this.titLabel.setText(searchMatcher.getTitle());
                if (bl) {
                    this.setBackground(SearchSystem.this.configList.getSelectionBackground());
                    this.setForeground(SearchSystem.this.configList.getSelectionForeground());
                } else {
                    this.setBackground(SearchSystem.this.configList.getBackground());
                    this.setForeground(SearchSystem.this.configList.getForeground());
                }
                this.chanLabel.setForeground(this.getForeground());
                this.chanLabel.setBackground(this.getBackground());
                this.artLabel.setForeground(this.getForeground());
                this.artLabel.setBackground(this.getBackground());
                this.titLabel.setForeground(this.getForeground());
                this.titLabel.setBackground(this.getBackground());
                this.chanName.setForeground(this.getForeground());
                this.chanName.setBackground(this.getBackground());
                this.artName.setForeground(this.getForeground());
                this.artName.setBackground(this.getBackground());
                this.titName.setForeground(this.getForeground());
                this.titName.setBackground(this.getBackground());
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MainWindow.gridColor));
                return this;
            }
        }
        this.configList.setCellRenderer(new SearchConfigRenderer());
        this.configList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SearchSystem.this.deleteButton.setEnabled(SearchSystem.this.configList.getSelectedValue() != null);
                if (SearchSystem.this.configList.getSelectedValues().length != 1) {
                    SearchSystem.this.ignoreUpdates = true;
                    try {
                        SearchSystem.this.channelEditor.setText("");
                        SearchSystem.this.channelEditor.setEnabled(false);
                        SearchSystem.this.artistEditor.setText("");
                        SearchSystem.this.artistEditor.setEnabled(false);
                        SearchSystem.this.titleEditor.setText("");
                        SearchSystem.this.titleEditor.setEnabled(false);
                    }
                    finally {
                        SearchSystem.this.ignoreUpdates = false;
                    }
                }
                SearchSystem.this.searchBeingEdited = (SearchMatcher)SearchSystem.this.configList.getSelectedValue();
                SearchSystem.this.ignoreUpdates = true;
                try {
                    SearchSystem.this.channelEditor.setText(SearchSystem.this.searchBeingEdited.getChannels());
                    SearchSystem.this.channelEditor.setEnabled(true);
                    SearchSystem.this.artistEditor.setText(SearchSystem.this.searchBeingEdited.getArtist());
                    SearchSystem.this.artistEditor.setEnabled(true);
                    SearchSystem.this.titleEditor.setText(SearchSystem.this.searchBeingEdited.getTitle());
                    SearchSystem.this.titleEditor.setEnabled(true);
                }
                finally {
                    SearchSystem.this.ignoreUpdates = false;
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.searchConfig.add((Component)new JScrollPane(this.configList), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JLabel jLabel = new JLabel("Channels: ");
        gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 22;
        gridBagConstraints2.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        jLabel = new JLabel("Artist: ");
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        jLabel = new JLabel("Title: ");
        gridBagConstraints2.gridy = 2;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        this.channelEditor = new JTextField();
        this.channelEditor.setEnabled(false);
        this.channelEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SearchSystem.this.searchBeingEdited.setChannels(SearchSystem.this.channelEditor.getText());
                    SearchSystem.this.searchList.set(SearchSystem.this.configList.getSelectedIndex(), SearchSystem.this.searchBeingEdited);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Toolkit.getDefaultToolkit().beep();
                    SearchSystem.this.channelEditor.requestFocus();
                }
            }
        });
        this.channelEditor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                SearchSystem.this.channelEditor.postActionEvent();
            }
        });
        this.channelEditor.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                String string = ((JTextField)jComponent).getText().trim();
                try {
                    SearchSystem.parseChannelList(string);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
        });
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        jPanel.add((Component)this.channelEditor, gridBagConstraints2);
        this.artistEditor = new JTextField();
        this.artistEditor.setEnabled(false);
        this.artistEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            private void doit() {
                if (SearchSystem.this.ignoreUpdates) {
                    return;
                }
                SearchSystem.this.searchBeingEdited.setArtist(SearchSystem.this.artistEditor.getText());
                SearchSystem.this.searchList.set(SearchSystem.this.configList.getSelectedIndex(), SearchSystem.this.searchBeingEdited);
            }
        });
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)this.artistEditor, gridBagConstraints2);
        this.titleEditor = new JTextField();
        this.titleEditor.setEnabled(false);
        this.titleEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doit();
            }

            private void doit() {
                if (SearchSystem.this.ignoreUpdates) {
                    return;
                }
                SearchSystem.this.searchBeingEdited.setTitle(SearchSystem.this.titleEditor.getText());
                SearchSystem.this.searchList.set(SearchSystem.this.configList.getSelectedIndex(), SearchSystem.this.searchBeingEdited);
            }
        });
        gridBagConstraints2.gridy = 2;
        jPanel.add((Component)this.titleEditor, gridBagConstraints2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        this.searchConfig.add((Component)jPanel, gridBagConstraints);
        JButton jButton = new JButton("+");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchSystem.this.searchList.add(SearchSystem.this.searchList.size(), new SearchMatcher());
                SearchSystem.this.configList.setSelectedIndex(SearchSystem.this.searchList.size() - 1);
            }
        });
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.searchConfig.add((Component)jButton, gridBagConstraints);
        this.deleteButton = new JButton("-");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = SearchSystem.this.configList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    SearchSystem.this.searchList.removeElement(objectArray[i]);
                }
            }
        });
        this.deleteButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 21;
        this.searchConfig.add((Component)this.deleteButton, gridBagConstraints);
        this.searchMatches = new JDialog(this.parent.getFrame(), "JXM - Search matches", false);
        this.searchMatches.getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this.matchList = new JList(this.matches);
        class SearchResultRenderer
        extends JPanel
        implements ListCellRenderer {
            MainWindow.ChannelInfoPanel infoPanel = new MainWindow.ChannelInfoPanel();

            public SearchResultRenderer() {
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                this.add((Component)this.infoPanel, gridBagConstraints);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.infoPanel.setChannelInfo((ChannelInfo)object);
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MainWindow.gridColor));
                return this;
            }
        }
        this.matchList.setCellRenderer(new SearchResultRenderer());
        this.matchList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            private void maybePopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = SearchSystem.this.matchList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                ChannelInfo channelInfo = (ChannelInfo)SearchSystem.this.matches.getElementAt(n);
                MainWindow mainWindow = SearchSystem.this.parent;
                mainWindow.getClass();
                MainWindow.ChannelPopupMenu channelPopupMenu = mainWindow.new MainWindow.ChannelPopupMenu(channelInfo, 0);
                channelPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.matchList.setFixedCellHeight(80);
        this.matchList.setFixedCellWidth(300);
        this.matchList.setVisibleRowCount(3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.searchMatches.getContentPane().add((Component)new JScrollPane(this.matchList), gridBagConstraints);
        this.searchMatches.pack();
        this.reloadFromPreferences();
    }

    public void addNewSong(ChannelInfo channelInfo) {
        SearchMatcher searchMatcher = new SearchMatcher();
        searchMatcher.setArtist(channelInfo.getChannelArtist());
        searchMatcher.setTitle(channelInfo.getChannelTitle());
        searchMatcher.setChannels(Integer.toString(channelInfo.getChannelNumber()));
        this.searchList.add(this.searchList.size(), searchMatcher);
        this.configList.setSelectedIndex(this.searchList.size() - 1);
    }

    public void reload() {
        this.reloadFromPreferences();
    }

    public void save() {
        this.saveToPreferences();
    }

    private void reloadFromPreferences() {
        String[] stringArray;
        Preferences preferences = JXM.myUserNode().node(SEARCH_LIST_KEY);
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    int n = Integer.parseInt(object.toString());
                    int n2 = Integer.parseInt(object2.toString());
                    return new Integer(n).compareTo(new Integer(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        });
        this.searchList.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = preferences.get(stringArray[i], "");
                SearchMatcher searchMatcher = new SearchMatcher(string);
                this.searchList.add(this.searchList.getSize(), searchMatcher);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void saveToPreferences() {
        for (int i = 0; i < this.searchList.size(); ++i) {
            SearchMatcher searchMatcher = (SearchMatcher)this.searchList.get(i);
            if (searchMatcher.getArtist().length() != 0 || searchMatcher.getTitle().length() != 0) continue;
            this.searchList.removeElement(searchMatcher);
            --i;
        }
        Preferences preferences = JXM.myUserNode().node(SEARCH_LIST_KEY);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        for (int i = 0; i < this.searchList.size(); ++i) {
            SearchMatcher searchMatcher = (SearchMatcher)this.searchList.get(i);
            preferences.put(Integer.toString(i), searchMatcher.serialize());
        }
    }

    private void turnOff() {
        this.matches.removeAllElements();
        this.searchMatches.setVisible(false);
    }

    public void update(ChannelInfo channelInfo) {
        block5: {
            int n;
            block4: {
                SearchMatcher searchMatcher;
                if (channelInfo == null) {
                    this.turnOff();
                    return;
                }
                int n2 = channelInfo.getChannelNumber();
                StringWrapper stringWrapper = matchAlgorithm.prepare(channelInfo.getChannelArtist().trim().toLowerCase());
                StringWrapper stringWrapper2 = matchAlgorithm.prepare(channelInfo.getChannelTitle().trim().toLowerCase());
                boolean bl = false;
                for (n = 0; n < this.searchList.size() && !(bl = (searchMatcher = (SearchMatcher)this.searchList.get(n)).isMatch(n2, stringWrapper, stringWrapper2)); ++n) {
                }
                if (!bl) break block4;
                n = channelInfo.getChannelNumber();
                for (int i = 0; i < this.matches.size(); ++i) {
                    ChannelInfo channelInfo2 = (ChannelInfo)this.matches.getElementAt(i);
                    if (channelInfo2.getChannelNumber() != n) continue;
                    this.matches.removeElement(channelInfo2);
                    break;
                }
                this.matches.add(this.matches.size(), channelInfo);
                if (this.searchMatches.isVisible() || n == RadioCommander.theRadio().getChannel()) break block5;
                this.parent.forceNormalView();
                this.searchMatches.setVisible(true);
                break block5;
            }
            n = channelInfo.getChannelNumber();
            for (int i = 0; i < this.matches.size(); ++i) {
                ChannelInfo channelInfo3 = (ChannelInfo)this.matches.getElementAt(i);
                if (channelInfo3.getChannelNumber() != n) continue;
                this.matches.removeElement(channelInfo3);
                if (this.matches.size() != 0 || !this.searchMatches.isVisible()) break;
                this.searchMatches.setVisible(false);
                break;
            }
        }
    }

    public class SearchMatcher {
        private String artistString;
        private String titleString;
        private String acceptableChannelsString;
        private StringWrapper artistMatcher;
        private StringWrapper titleMatcher;
        private int[] acceptableChannels;

        public SearchMatcher() {
            this.setChannels(null);
            this.setArtist(null);
            this.setTitle(null);
        }

        public void setChannels(String string) {
            if (string == null) {
                string = "";
            }
            string = string.trim();
            this.acceptableChannels = SearchSystem.parseChannelList(string);
            this.acceptableChannelsString = string;
        }

        public void setArtist(String string) {
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            if (string == null) {
                this.artistString = null;
                this.artistMatcher = null;
            } else {
                this.artistString = string;
                this.artistMatcher = matchAlgorithm.prepare(string.trim().toLowerCase());
            }
        }

        public void setTitle(String string) {
            if (string != null && string.trim().length() == 0) {
                string = null;
            }
            if (string == null) {
                this.titleString = null;
                this.titleMatcher = null;
            } else {
                this.titleString = string;
                this.titleMatcher = matchAlgorithm.prepare(string.trim().toLowerCase());
            }
        }

        public String getArtist() {
            return this.artistString == null ? "" : this.artistString;
        }

        public String getTitle() {
            return this.titleString == null ? "" : this.titleString;
        }

        public String getChannels() {
            return this.acceptableChannelsString;
        }

        public SearchMatcher(String string) {
            this();
            String[] stringArray = string.split(":", -1);
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("Wrong number of fields.");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    stringArray[i] = URLDecoder.decode(stringArray[i], "US-ASCII");
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.setChannels(stringArray[0]);
            this.setArtist(stringArray[1]);
            this.setTitle(stringArray[2]);
        }

        public String serialize() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(URLEncoder.encode(this.getChannels(), "US-ASCII"));
                stringBuffer.append(':');
                stringBuffer.append(URLEncoder.encode(this.getArtist(), "US-ASCII"));
                stringBuffer.append(':');
                stringBuffer.append(URLEncoder.encode(this.getTitle(), "US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return stringBuffer.toString();
        }

        public boolean isMatch(int n, StringWrapper stringWrapper, StringWrapper stringWrapper2) {
            if (this.artistMatcher == null && this.titleMatcher == null) {
                return false;
            }
            if (this.acceptableChannels.length > 0 && Arrays.binarySearch(this.acceptableChannels, n) < 0) {
                return false;
            }
            if (this.artistMatcher != null && matchAlgorithm.score(this.artistMatcher, stringWrapper) < SearchSystem.this.getWinningScore()) {
                return false;
            }
            return this.titleMatcher == null || !(matchAlgorithm.score(this.titleMatcher, stringWrapper2) < SearchSystem.this.getWinningScore());
        }
    }
}

