/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.JXM.JXM;
import com.kfu.JXM.MainWindow;
import com.kfu.JXM.MemoryListItem;
import com.kfu.xm.ChannelInfo;
import com.kfu.xm.RadioCommander;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MemoryPanel
extends JDialog {
    private MainWindow parent;
    private JList memoryList;
    private DefaultListModel memoryListModel;
    private JButton deleteButton;
    private JTextArea notesField;
    private boolean ignoreNotesChange = false;
    private static final int memoryCellHeight = 80;
    private static final int memoryCellWidth = 300;
    private static DateFormat myFormatter = DateFormat.getDateTimeInstance();
    private static final String MEMORY_NODE = "MemoryList";

    public MemoryPanel(MainWindow mainWindow) {
        super(mainWindow.getFrame(), "JXM - Notebook", false);
        this.parent = mainWindow;
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.memoryList = new JList();
        this.memoryListModel = new DefaultListModel();
        this.memoryList.setModel(this.memoryListModel);
        this.memoryList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            private void maybePopup(MouseEvent mouseEvent) {
                if (!RadioCommander.theRadio().isOn()) {
                    return;
                }
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = MemoryPanel.this.memoryList.locationToIndex(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                MemoryListItem memoryListItem = (MemoryListItem)MemoryPanel.this.memoryListModel.getElementAt(n);
                MainWindow mainWindow = MemoryPanel.this.parent;
                mainWindow.getClass();
                MainWindow.ChannelPopupMenu channelPopupMenu = mainWindow.new MainWindow.ChannelPopupMenu(memoryListItem.getChannelInfo(), 1);
                channelPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        class MemoryCellRenderer
        extends JPanel
        implements ListCellRenderer {
            JLabel dateField;
            MainWindow.ChannelInfoPanel channelInfoPanel;

            public MemoryCellRenderer() {
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.channelInfoPanel = new MainWindow.ChannelInfoPanel();
                this.channelInfoPanel.setOpaque(false);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(10, 10, 0, 10);
                gridBagConstraints.fill = 1;
                this.add((Component)this.channelInfoPanel, gridBagConstraints);
                this.dateField = new JLabel();
                this.dateField.setFont(new Font(null, 0, 9));
                this.dateField.setOpaque(false);
                this.dateField.setHorizontalAlignment(0);
                this.dateField.setVerticalAlignment(0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(0, 10, 10, 10);
                this.add((Component)this.dateField, gridBagConstraints);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                MemoryListItem memoryListItem = (MemoryListItem)object;
                Date date = memoryListItem.getDate();
                ChannelInfo channelInfo = memoryListItem.getChannelInfo();
                if (bl) {
                    this.setForeground(jList.getSelectionForeground());
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setForeground(null);
                    this.setBackground(null);
                }
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MainWindow.gridColor));
                this.dateField.setText(myFormatter.format(date));
                this.channelInfoPanel.setChannelInfo(channelInfo);
                return this;
            }
        }
        this.memoryList.setCellRenderer(new MemoryCellRenderer());
        this.memoryList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = MemoryPanel.this.memoryList.getSelectedIndices();
                MemoryPanel.this.deleteButton.setEnabled(nArray.length >= 0);
                MemoryPanel.this.ignoreNotesChange = true;
                try {
                    if (nArray.length == 1) {
                        MemoryPanel.this.notesField.setEnabled(true);
                        MemoryListItem memoryListItem = (MemoryListItem)MemoryPanel.this.memoryList.getSelectedValue();
                        MemoryPanel.this.notesField.setText(memoryListItem.getNotes());
                    } else {
                        MemoryPanel.this.notesField.setEnabled(false);
                        MemoryPanel.this.notesField.setText("");
                    }
                }
                finally {
                    MemoryPanel.this.ignoreNotesChange = false;
                }
            }
        });
        this.memoryList.setFixedCellHeight(80);
        this.memoryList.setFixedCellWidth(300);
        this.memoryList.setVisibleRowCount(3);
        JScrollPane jScrollPane = new JScrollPane(this.memoryList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        this.notesField = new JTextArea();
        this.notesField.setRows(5);
        this.notesField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            private void doIt() {
                if (MemoryPanel.this.ignoreNotesChange) {
                    return;
                }
                MemoryListItem memoryListItem = (MemoryListItem)MemoryPanel.this.memoryList.getSelectedValue();
                memoryListItem.setNotes(MemoryPanel.this.notesField.getText());
            }
        });
        jScrollPane = new JScrollPane(this.notesField);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Notes"));
        this.notesField.setEnabled(false);
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = MemoryPanel.this.memoryList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    MemoryPanel.this.memoryListModel.removeElement(objectArray[i]);
                }
                MemoryPanel.this.deleteButton.setEnabled(false);
            }
        });
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.getContentPane().add((Component)this.deleteButton, gridBagConstraints);
        this.loadMemory();
        this.pack();
    }

    public void quit() {
        this.saveMemory();
    }

    private void loadMemory() {
        String[] stringArray;
        Preferences preferences = JXM.myUserNode().node(MEMORY_NODE);
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        this.memoryListModel.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            MemoryListItem memoryListItem;
            String string = preferences.get(stringArray[i], "");
            try {
                memoryListItem = new MemoryListItem(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            for (n = 0; n < this.memoryListModel.getSize() && ((MemoryListItem)this.memoryListModel.getElementAt(n)).getDate().getTime() <= memoryListItem.getDate().getTime(); ++n) {
            }
            this.memoryListModel.add(n, memoryListItem);
        }
    }

    private void saveMemory() {
        Preferences preferences = JXM.myUserNode().node(MEMORY_NODE);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
        for (int i = 0; i < this.memoryListModel.getSize(); ++i) {
            MemoryListItem memoryListItem = (MemoryListItem)this.memoryListModel.getElementAt(i);
            String string = memoryListItem.serialize();
            preferences.put(Integer.toString(i), string);
        }
    }

    public void memorize(ChannelInfo channelInfo) {
        MemoryListItem memoryListItem = new MemoryListItem(channelInfo);
        this.memoryListModel.add(this.memoryListModel.getSize(), memoryListItem);
        this.memoryList.setSelectedValue(memoryListItem, true);
        this.setVisible(true);
    }
}

