/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.xm.ChannelInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;

public class MemoryListItem {
    private Date when;
    private ChannelInfo info;
    private String notes;

    public MemoryListItem(ChannelInfo channelInfo) {
        this.when = new Date();
        this.info = channelInfo;
    }

    public MemoryListItem(Date date, ChannelInfo channelInfo) {
        this.when = date;
        this.info = channelInfo;
    }

    public MemoryListItem(String string) {
        String[] stringArray = string.split(":", -1);
        if (stringArray.length != 7 && stringArray.length != 8) {
            throw new IllegalArgumentException("Wrong number of serialized fields.");
        }
        try {
            this.when = new Date(Long.parseLong(stringArray[0]));
            this.info = new ChannelInfo(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), URLDecoder.decode(stringArray[4], "US-ASCII"), URLDecoder.decode(stringArray[3], "US-ASCII"), URLDecoder.decode(stringArray[5], "US-ASCII"), URLDecoder.decode(stringArray[6], "US-ASCII"));
            if (stringArray.length >= 8) {
                this.notes = URLDecoder.decode(stringArray[7], "US-ASCII");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid serialization");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public Date getDate() {
        return this.when;
    }

    public ChannelInfo getChannelInfo() {
        return this.info;
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(this.getDate().getTime()));
        stringBuffer.append(":");
        stringBuffer.append(this.getChannelInfo().getChannelNumber());
        stringBuffer.append(":");
        stringBuffer.append(this.getChannelInfo().getServiceID());
        stringBuffer.append(":");
        try {
            stringBuffer.append(URLEncoder.encode(this.getChannelInfo().getChannelName(), "US-ASCII"));
            stringBuffer.append(":");
            stringBuffer.append(URLEncoder.encode(this.getChannelInfo().getChannelGenre(), "US-ASCII"));
            stringBuffer.append(":");
            stringBuffer.append(URLEncoder.encode(this.getChannelInfo().getChannelArtist(), "US-ASCII"));
            stringBuffer.append(":");
            stringBuffer.append(URLEncoder.encode(this.getChannelInfo().getChannelTitle(), "US-ASCII"));
            stringBuffer.append(":");
            stringBuffer.append(URLEncoder.encode(this.getNotes(), "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

