/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;

public class TopologyValidationError {
    public static int ERROR = 0;
    public static int REPEATED_POINT = 1;
    public static int HOLE_OUTSIDE_SHELL = 2;
    public static int NESTED_HOLES = 3;
    public static int DISCONNECTED_INTERIOR = 4;
    public static int SELF_INTERSECTION = 5;
    public static int RING_SELF_INTERSECTION = 6;
    public static int NESTED_SHELLS = 7;
    public static int DUPLICATE_RINGS = 8;
    public static int TOO_FEW_POINTS = 9;
    private static String[] errMsg = new String[]{"Topology Validation Error", "Repeated Point", "Hole lies outside shell", "Holes are nested", "Interior is disconnected", "Self-intersection", "Ring Self-intersection", "Nested shells", "Duplicate Rings", "Too few points in geometry component"};
    private int errorType;
    private Coordinate pt;

    public TopologyValidationError(int n, Coordinate coordinate) {
        this.errorType = n;
        this.pt = (Coordinate)coordinate.clone();
    }

    public TopologyValidationError(int n) {
        this(n, null);
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return errMsg[this.errorType];
    }

    public String toString() {
        return this.getMessage() + " at or near point " + this.pt;
    }
}

