/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.buffer.RightmostEdgeFinder;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class BufferSubgraph
implements Comparable {
    private RightmostEdgeFinder finder;
    private List dirEdgeList = new ArrayList();
    private List nodes = new ArrayList();
    private Coordinate rightMostCoord = null;

    public BufferSubgraph(CGAlgorithms cGAlgorithms) {
        this.finder = new RightmostEdgeFinder(cGAlgorithms);
    }

    public List getDirectedEdges() {
        return this.dirEdgeList;
    }

    public List getNodes() {
        return this.nodes;
    }

    public Coordinate getRightmostCoordinate() {
        return this.rightMostCoord;
    }

    public void create(Node node) {
        this.addReachable(node);
        this.finder.findEdge(this.dirEdgeList);
        this.rightMostCoord = this.finder.getCoordinate();
    }

    private void addReachable(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.add(node);
        while (!stack.empty()) {
            Node node2 = (Node)stack.pop();
            this.add(node2, stack);
        }
    }

    private void add(Node node, Stack stack) {
        node.setVisited(true);
        this.nodes.add(node);
        Iterator iterator = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            this.dirEdgeList.add(directedEdge);
            DirectedEdge directedEdge2 = directedEdge.getSym();
            Node node2 = directedEdge2.getNode();
            if (node2.isVisited()) continue;
            stack.push(node2);
        }
    }

    private void clearVisitedEdges() {
        Iterator iterator = this.dirEdgeList.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            directedEdge.setVisited(false);
        }
    }

    public void computeDepth(int n) {
        this.clearVisitedEdges();
        DirectedEdge directedEdge = this.finder.getEdge();
        Node node = directedEdge.getNode();
        Label label = directedEdge.getLabel();
        directedEdge.setEdgeDepths(2, n);
        this.copySymDepths(directedEdge);
        this.computeDepths(directedEdge);
    }

    private void computeDepths(DirectedEdge directedEdge) {
        HashSet<Node> hashSet = new HashSet<Node>();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Node node = directedEdge.getNode();
        linkedList.addLast(node);
        hashSet.add(node);
        directedEdge.setVisited(true);
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.removeFirst();
            hashSet.add(node2);
            this.computeNodeDepth(node2);
            Iterator iterator = ((DirectedEdgeStar)node2.getEdges()).iterator();
            while (iterator.hasNext()) {
                Node node3;
                DirectedEdge directedEdge2 = (DirectedEdge)iterator.next();
                DirectedEdge directedEdge3 = directedEdge2.getSym();
                if (directedEdge3.isVisited() || hashSet.contains(node3 = directedEdge3.getNode())) continue;
                linkedList.addLast(node3);
                hashSet.add(node3);
            }
        }
    }

    private void computeNodeDepth(Node node) {
        DirectedEdge directedEdge;
        DirectedEdge directedEdge2 = null;
        Iterator iterator = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (iterator.hasNext()) {
            directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isVisited() && !directedEdge.getSym().isVisited()) continue;
            directedEdge2 = directedEdge;
            break;
        }
        Assert.isTrue(directedEdge2 != null, "unable to find edge to compute depths at " + node.getCoordinate());
        ((DirectedEdgeStar)node.getEdges()).computeDepths(directedEdge2);
        iterator = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (iterator.hasNext()) {
            directedEdge = (DirectedEdge)iterator.next();
            directedEdge.setVisited(true);
            this.copySymDepths(directedEdge);
        }
    }

    private void copySymDepths(DirectedEdge directedEdge) {
        DirectedEdge directedEdge2 = directedEdge.getSym();
        directedEdge2.setDepth(1, directedEdge.getDepth(2));
        directedEdge2.setDepth(2, directedEdge.getDepth(1));
    }

    public void findResultEdges() {
        Iterator iterator = this.dirEdgeList.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (directedEdge.getDepth(2) < 1 || directedEdge.getDepth(1) > 0 || directedEdge.isInteriorAreaEdge()) continue;
            directedEdge.setInResult(true);
        }
    }

    public int compareTo(Object object) {
        BufferSubgraph bufferSubgraph = (BufferSubgraph)object;
        if (this.rightMostCoord.x < bufferSubgraph.rightMostCoord.x) {
            return -1;
        }
        if (this.rightMostCoord.x > bufferSubgraph.rightMostCoord.x) {
            return 1;
        }
        return 0;
    }
}

