/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.operation.buffer.BufferBuilder;
import com.vividsolutions.jts.precision.SimpleGeometryPrecisionReducer;

public class BufferOp {
    public static final int CAP_ROUND = 1;
    public static final int CAP_BUTT = 2;
    public static final int CAP_SQUARE = 3;
    private static int MAX_PRECISION_DIGITS = 12;
    private Geometry argGeom;
    private double distance;
    private int quadrantSegments = 8;
    private int endCapStyle = 1;
    private Geometry resultGeometry = null;
    private TopologyException saveException;

    private static double precisionScaleFactor(Geometry geometry, double d, int n) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double d2 = Math.max(envelope.getHeight(), envelope.getWidth());
        double d3 = d > 0.0 ? d : 0.0;
        double d4 = d2 + 2.0 * d3;
        int n2 = (int)(Math.log(d4) / Math.log(10.0) + 1.0);
        int n3 = n2 - n;
        double d5 = Math.pow(10.0, -n3);
        return d5;
    }

    public static Geometry bufferOp(Geometry geometry, double d) {
        BufferOp bufferOp = new BufferOp(geometry);
        Geometry geometry2 = bufferOp.getResultGeometry(d);
        return geometry2;
    }

    public static Geometry bufferOp(Geometry geometry, double d, int n) {
        BufferOp bufferOp = new BufferOp(geometry);
        bufferOp.setQuadrantSegments(n);
        Geometry geometry2 = bufferOp.getResultGeometry(d);
        return geometry2;
    }

    public BufferOp(Geometry geometry) {
        this.argGeom = geometry;
    }

    public void setEndCapStyle(int n) {
        this.endCapStyle = n;
    }

    public void setQuadrantSegments(int n) {
        this.quadrantSegments = n;
    }

    public Geometry getResultGeometry(double d) {
        this.distance = d;
        this.computeGeometry();
        return this.resultGeometry;
    }

    public Geometry getResultGeometry(double d, int n) {
        this.distance = d;
        this.setQuadrantSegments(n);
        this.computeGeometry();
        return this.resultGeometry;
    }

    private void computeGeometry() {
        this.bufferOriginalPrecision();
        if (this.resultGeometry != null) {
            return;
        }
        for (int i = MAX_PRECISION_DIGITS; i >= 0; --i) {
            try {
                this.bufferFixedPrecision(i);
            }
            catch (TopologyException topologyException) {
                this.saveException = topologyException;
            }
            if (this.resultGeometry == null) continue;
            return;
        }
        throw this.saveException;
    }

    private void bufferOriginalPrecision() {
        try {
            BufferBuilder bufferBuilder = new BufferBuilder();
            bufferBuilder.setQuadrantSegments(this.quadrantSegments);
            bufferBuilder.setEndCapStyle(this.endCapStyle);
            this.resultGeometry = bufferBuilder.buffer(this.argGeom, this.distance);
        }
        catch (TopologyException topologyException) {
            this.saveException = topologyException;
        }
    }

    private void bufferFixedPrecision(int n) {
        double d = BufferOp.precisionScaleFactor(this.argGeom, this.distance, n);
        PrecisionModel precisionModel = new PrecisionModel(d);
        SimpleGeometryPrecisionReducer simpleGeometryPrecisionReducer = new SimpleGeometryPrecisionReducer(precisionModel);
        Geometry geometry = simpleGeometryPrecisionReducer.reduce(this.argGeom);
        BufferBuilder bufferBuilder = new BufferBuilder();
        bufferBuilder.setWorkingPrecisionModel(precisionModel);
        bufferBuilder.setQuadrantSegments(this.quadrantSegments);
        this.resultGeometry = bufferBuilder.buffer(geometry, this.distance);
    }
}

