/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geomgraph.GeometryGraph;

public class GeometryGraphOperation {
    protected final CGAlgorithms cga = new CGAlgorithms();
    protected final LineIntersector li = new RobustLineIntersector();
    protected PrecisionModel resultPrecisionModel;
    protected GeometryGraph[] arg;

    public GeometryGraphOperation(Geometry geometry, Geometry geometry2) {
        if (geometry.getPrecisionModel().compareTo(geometry2.getPrecisionModel()) >= 0) {
            this.setComputationPrecision(geometry.getPrecisionModel());
        } else {
            this.setComputationPrecision(geometry2.getPrecisionModel());
        }
        this.arg = new GeometryGraph[2];
        this.arg[0] = new GeometryGraph(0, geometry);
        this.arg[1] = new GeometryGraph(1, geometry2);
    }

    public GeometryGraphOperation(Geometry geometry) {
        this.setComputationPrecision(geometry.getPrecisionModel());
        this.arg = new GeometryGraph[1];
        this.arg[0] = new GeometryGraph(0, geometry);
    }

    public Geometry getArgGeometry(int n) {
        return this.arg[n].getGeometry();
    }

    protected void setComputationPrecision(PrecisionModel precisionModel) {
        this.resultPrecisionModel = precisionModel;
        this.li.setPrecisionModel(this.resultPrecisionModel);
    }
}

