/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.Node;
import java.util.ArrayList;
import java.util.List;

public abstract class NodeBase {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[4];

    public static int getSubnodeIndex(Envelope envelope, Coordinate coordinate) {
        int n = -1;
        if (envelope.getMinX() >= coordinate.x) {
            if (envelope.getMinY() >= coordinate.y) {
                n = 3;
            }
            if (envelope.getMaxY() <= coordinate.y) {
                n = 1;
            }
        }
        if (envelope.getMaxX() <= coordinate.x) {
            if (envelope.getMinY() >= coordinate.y) {
                n = 2;
            }
            if (envelope.getMaxY() <= coordinate.y) {
                n = 0;
            }
        }
        return n;
    }

    public List getItems() {
        return this.items;
    }

    public void add(Object object) {
        this.items.add(object);
    }

    public List addAllItems(List list) {
        list.addAll(this.items);
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            this.subnode[i].addAllItems(list);
        }
        return list;
    }

    protected abstract boolean isSearchMatch(Envelope var1);

    public void addAllItemsFromOverlapping(Envelope envelope, List list) {
        if (!this.isSearchMatch(envelope)) {
            return;
        }
        list.addAll(this.items);
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            this.subnode[i].addAllItemsFromOverlapping(envelope, list);
        }
    }

    int depth() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2;
            if (this.subnode[i] == null || (n2 = this.subnode[i].depth()) <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    int size() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            n += this.subnode[i].size();
        }
        return n + this.items.size();
    }

    int nodeCount() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            n += this.subnode[i].size();
        }
        return n + 1;
    }
}

