/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;

public class NonRobustLineIntersector
extends LineIntersector {
    public static boolean isSameSignAndNonZero(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return false;
        }
        return d < 0.0 && d2 < 0.0 || d > 0.0 && d2 > 0.0;
    }

    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        this.isProper = false;
        double d = coordinate3.y - coordinate2.y;
        double d2 = coordinate2.x - coordinate3.x;
        double d3 = coordinate3.x * coordinate2.y - coordinate2.x * coordinate3.y;
        double d4 = d * coordinate.x + d2 * coordinate.y + d3;
        if (d4 != 0.0) {
            this.result = 0;
            return;
        }
        double d5 = this.rParameter(coordinate2, coordinate3, coordinate);
        if (d5 < 0.0 || d5 > 1.0) {
            this.result = 0;
            return;
        }
        this.isProper = true;
        if (coordinate.equals(coordinate2) || coordinate.equals(coordinate3)) {
            this.isProper = false;
        }
        this.result = 1;
    }

    protected int computeIntersect(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        this.isProper = false;
        double d = coordinate2.y - coordinate.y;
        double d2 = coordinate.x - coordinate2.x;
        double d3 = coordinate2.x * coordinate.y - coordinate.x * coordinate2.y;
        double d4 = d * coordinate3.x + d2 * coordinate3.y + d3;
        double d5 = d * coordinate4.x + d2 * coordinate4.y + d3;
        if (d4 != 0.0 && d5 != 0.0 && NonRobustLineIntersector.isSameSignAndNonZero(d4, d5)) {
            return 0;
        }
        double d6 = coordinate4.y - coordinate3.y;
        double d7 = coordinate3.x - coordinate4.x;
        double d8 = coordinate4.x * coordinate3.y - coordinate3.x * coordinate4.y;
        double d9 = d6 * coordinate.x + d7 * coordinate.y + d8;
        double d10 = d6 * coordinate2.x + d7 * coordinate2.y + d8;
        if (d9 != 0.0 && d10 != 0.0 && NonRobustLineIntersector.isSameSignAndNonZero(d9, d10)) {
            return 0;
        }
        double d11 = d * d7 - d6 * d2;
        if (d11 == 0.0) {
            return this.computeCollinearIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        }
        double d12 = d2 * d8 - d7 * d3;
        this.pa.x = d12 / d11;
        double d13 = d6 * d3 - d * d8;
        this.pa.y = d13 / d11;
        this.isProper = true;
        if (this.pa.equals(coordinate) || this.pa.equals(coordinate2) || this.pa.equals(coordinate3) || this.pa.equals(coordinate4)) {
            this.isProper = false;
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(this.pa);
        }
        return 1;
    }

    private int computeCollinearIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d;
        Coordinate coordinate5;
        double d2;
        Coordinate coordinate6;
        double d3;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = this.rParameter(coordinate, coordinate2, coordinate3);
        if (d6 < (d3 = this.rParameter(coordinate, coordinate2, coordinate4))) {
            coordinate6 = coordinate3;
            d2 = d6;
            coordinate5 = coordinate4;
            d = d3;
        } else {
            coordinate6 = coordinate4;
            d2 = d3;
            coordinate5 = coordinate3;
            d = d6;
        }
        if (d2 > d5 || d < d4) {
            return 0;
        }
        if (coordinate5 == coordinate) {
            this.pa.setCoordinate(coordinate);
            return 1;
        }
        if (coordinate6 == coordinate2) {
            this.pa.setCoordinate(coordinate2);
            return 1;
        }
        this.pa.setCoordinate(coordinate);
        if (d2 > d4) {
            this.pa.setCoordinate(coordinate6);
        }
        this.pb.setCoordinate(coordinate2);
        if (d < d5) {
            this.pb.setCoordinate(coordinate5);
        }
        return 2;
    }

    private double rParameter(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d;
        double d2 = Math.abs(coordinate2.x - coordinate.x);
        double d3 = d2 > (d = Math.abs(coordinate2.y - coordinate.y)) ? (coordinate3.x - coordinate.x) / (coordinate2.x - coordinate.x) : (coordinate3.y - coordinate.y) / (coordinate2.y - coordinate.y);
        return d3;
    }
}

