/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ToolboxDialog
extends JDialog {
    private ArrayList buttons = new ArrayList();
    private ArrayList toolBars = new ArrayList();
    private GUIUtil.Location initialLocation = new GUIUtil.Location(0, false, 0, false);
    private WorkbenchContext context;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel centerPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel toolbarsPanel = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();

    public AbstractButton getButton(Class cursorToolClass) {
        Iterator i = this.toolBars.iterator();
        while (i.hasNext()) {
            WorkbenchToolBar toolBar = (WorkbenchToolBar)i.next();
            AbstractButton button = toolBar.getButton(cursorToolClass);
            if (button == null) continue;
            return button;
        }
        return null;
    }

    public WorkbenchToolBar getToolBar() {
        if (this.toolBars.isEmpty()) {
            this.addToolBar();
        }
        return (WorkbenchToolBar)this.toolBars.get(this.toolBars.size() - 1);
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool) {
        return this.add(tool, null);
    }

    public WorkbenchToolBar.ToolConfig add(CursorTool tool, EnableCheck enableCheck) {
        WorkbenchToolBar.ToolConfig config = this.getToolBar().addCursorTool(tool);
        JToggleButton button = config.getButton();
        this.getToolBar().setEnableCheck(button, enableCheck != null ? enableCheck : new MultiEnableCheck());
        this.registerButton(button, enableCheck);
        return config;
    }

    public void addPlugIn(PlugIn plugIn, EnableCheck enableCheck, Icon icon) {
        this.registerButton(this.getToolBar().addPlugIn(icon, plugIn, enableCheck, this.context), enableCheck);
    }

    private void registerButton(AbstractButton button, EnableCheck enableCheck) {
        this.buttons.add(button);
    }

    public void addToolBar() {
        this.toolBars.add(new WorkbenchToolBar(this.context, this.context.getWorkbench().getFrame().getToolBar().getButtonGroup()));
        this.getToolBar().setBorder(null);
        this.getToolBar().setFloatable(false);
        this.gridLayout1.setRows(this.toolBars.size());
        this.toolbarsPanel.add(this.getToolBar());
    }

    public ToolboxDialog(final WorkbenchContext context) {
        super(context.getWorkbench().getFrame(), "", false);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.context = context;
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                if (ToolboxDialog.this.buttons.contains(context.getWorkbench().getFrame().getToolBar().getSelectedCursorToolButton())) {
                    context.getWorkbench().getFrame().getToolBar().getButtonGroup().getElements().nextElement().doClick();
                }
            }
        });
    }

    public void finishAddingComponents() {
        this.pack();
        GUIUtil.setLocation(this, this.initialLocation, this.context.getWorkbench().getFrame().getDesktopPane());
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.centerPanel.setLayout(this.borderLayout2);
        this.toolbarsPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.toolbarsPanel, "North");
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public void updateEnabledState() {
        Iterator i = this.toolBars.iterator();
        while (i.hasNext()) {
            WorkbenchToolBar toolBar = (WorkbenchToolBar)i.next();
            toolBar.updateEnabledState();
        }
    }

    public void setInitialLocation(GUIUtil.Location location) {
        this.initialLocation = location;
    }
}

