/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SRSUtils;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SRSWizardPanel
extends JPanel
implements WizardPanel {
    public static final String SRS_KEY = "SRS";
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Map dataMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel srsLabel = new JLabel();
    private JPanel fillerPanel = new JPanel();
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private JComboBox comboBox = new JComboBox();

    public SRSWizardPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    public String getInstructions() {
        return "The layers you have chosen support more than one Coordinate Reference system. Please choose the one that matches the rest of your data.";
    }

    void jbInit() throws Exception {
        this.srsLabel.setText("Coordinate Reference System:");
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.srsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(2, 10, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.comboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void exitingToRight() {
        int index = this.comboBox.getSelectedIndex();
        String srsCode = (String)this.getCommonSrsList().get(index);
        this.dataMap.put(SRS_KEY, srsCode);
    }

    private List getCommonSrsList() {
        return (List)this.dataMap.get("COMMON_SRS_LIST");
    }

    public void enteredFromLeft(Map dataMap) {
        this.dataMap = dataMap;
        Iterator i = this.getCommonSrsList().iterator();
        while (i.hasNext()) {
            String srs = (String)i.next();
            String srsName = SRSUtils.getName(srs);
            this.comboBoxModel.addElement(srsName);
        }
        this.comboBox.setModel(this.comboBoxModel);
    }

    public String getTitle() {
        return "Select Coordinate Reference System";
    }

    public String getID() {
        return this.getClass().getName();
    }

    public boolean isInputValid() {
        return true;
    }

    public String getNextID() {
        return null;
    }
}

