/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.wms.MapLayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class MapLayerTreeModel
extends DefaultTreeModel {
    private boolean sorted = false;

    public MapLayerTreeModel(MapLayer topLayer) {
        super(new LayerNode(topLayer, null));
        ((LayerNode)this.getRoot()).mapLayerTreeModel = this;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
        this.reload();
    }

    public static class LayerNode
    implements TreeNode,
    Comparable {
        private MapLayer layer;
        private MapLayerTreeModel mapLayerTreeModel;

        public LayerNode(MapLayer layer, MapLayerTreeModel mapLayerTreeModel) {
            this.layer = layer;
            this.mapLayerTreeModel = mapLayerTreeModel;
        }

        public boolean isContainer() {
            return this.layer.getName() == null;
        }

        public MapLayer getLayer() {
            return this.layer;
        }

        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this.childList().get(childIndex);
        }

        public int getChildCount() {
            return this.childList().size();
        }

        public TreeNode getParent() {
            return new LayerNode(this.layer.getParent(), this.mapLayerTreeModel);
        }

        public int getIndex(TreeNode node) {
            return this.childList().indexOf(node);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public Enumeration children() {
            return new Vector(this.childList()).elements();
        }

        private List childList() {
            ArrayList<LayerNode> children = new ArrayList<LayerNode>();
            Iterator i = this.layer.getSubLayerList().iterator();
            while (i.hasNext()) {
                MapLayer layer = (MapLayer)i.next();
                children.add(new LayerNode(layer, this.mapLayerTreeModel));
            }
            if (this.mapLayerTreeModel.sorted) {
                Collections.sort(children);
            }
            return children;
        }

        public boolean equals(Object o) {
            LayerNode other = (LayerNode)o;
            return this.layer == other.layer;
        }

        public int compareTo(Object o) {
            LayerNode other = (LayerNode)o;
            return this.layer.getTitle().compareTo(other.layer.getTitle());
        }
    }
}

