/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SnapVerticesOp {
    public static final String INSERT_VERTICES_IF_NECESSARY_KEY = (class$com$vividsolutions$jump$workbench$ui$cursortool$editing$SnapVerticesOp == null ? (class$com$vividsolutions$jump$workbench$ui$cursortool$editing$SnapVerticesOp = SnapVerticesOp.class$("com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesOp")) : class$com$vividsolutions$jump$workbench$ui$cursortool$editing$SnapVerticesOp).getName() + " - INSERT_VERTICES_IF_NECESSARY";
    private static final String NO_TARGET_VERTICES_IN_FENCE_WARNING = "Fence contains no vertices of the selected feature, part, or linestring";
    private GeometryEditor geometryEditor = new GeometryEditor();
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$cursortool$editing$SnapVerticesOp;

    private Collection featuresInFence(Layer layer, Geometry fence, LayerViewPanel panel) {
        Collection featuresInFence = (Collection)panel.visibleLayerToFeaturesInFenceMap(fence).get(layer);
        if (featuresInFence == null) {
            return new ArrayList();
        }
        return featuresInFence;
    }

    public Coordinate pickTarget(Geometry targetGeometry, Geometry fence, Coordinate suggestedTarget) throws Exception {
        List verticesInFence = VerticesInFencePlugIn.verticesInFence(targetGeometry, fence, true).getCoordinates();
        if (verticesInFence.isEmpty()) {
            return null;
        }
        return CoordUtil.closest(verticesInFence, suggestedTarget);
    }

    public boolean execute(Geometry fence, Collection editableLayers, boolean rollingBackInvalidEdits, final LayerViewPanel panel, Task task, Coordinate suggestedTarget, Feature targetFeature, boolean insertVerticesIfNecessary) throws Exception {
        Map editableLayerToFeaturesInFenceMap = this.editableLayerToFeaturesInFenceMap(editableLayers, fence, panel);
        Collection editableFeatures = CollectionUtil.concatenate(editableLayerToFeaturesInFenceMap.values());
        if (editableFeatures.isEmpty()) {
            panel.getContext().warnUser("Fence contains no features from editable layers");
            return false;
        }
        if (VerticesInFencePlugIn.verticesInFence(targetFeature.getGeometry(), fence, true).getCoordinates().isEmpty() && VerticesInFencePlugIn.verticesInFence(FeatureUtil.toGeometries(editableFeatures), fence, true).isEmpty()) {
            panel.getContext().warnUser(NO_TARGET_VERTICES_IN_FENCE_WARNING);
            return false;
        }
        Geometry targetGeometry = targetFeature.getGeometry();
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        Iterator i = editableLayers.iterator();
        while (i.hasNext()) {
            Layer editableLayer = (Layer)i.next();
            Collection featuresInFence = (Collection)editableLayerToFeaturesInFenceMap.get(editableLayer);
            EditTransaction transaction = new EditTransaction(featuresInFence, "Snap Vertices Together", editableLayer, rollingBackInvalidEdits, false, panel);
            transactions.add(transaction);
            if (!insertVerticesIfNecessary) continue;
            this.insertVerticesIfNecessary(transaction, suggestedTarget, fence);
            if (!featuresInFence.contains(targetFeature)) continue;
            targetGeometry = transaction.getGeometry(targetFeature);
        }
        final Coordinate target = this.pickTarget(targetGeometry, fence, suggestedTarget);
        if (target == null) {
            panel.getContext().warnUser(NO_TARGET_VERTICES_IN_FENCE_WARNING);
            return false;
        }
        boolean geometryChanged = this.moveVertices(transactions, fence, target);
        if (!geometryChanged) {
            return true;
        }
        return EditTransaction.commit(transactions, new EditTransaction.SuccessAction(){

            public void run() {
                try {
                    SnapVerticesOp.this.indicateSuccess(target, panel);
                }
                catch (Throwable t) {
                    panel.getContext().warnUser(t.toString());
                }
            }
        });
    }

    private boolean moveVertices(List transactions, Geometry fence, Coordinate target) {
        boolean geometryChanged = false;
        Iterator i = transactions.iterator();
        while (i.hasNext()) {
            EditTransaction transaction = (EditTransaction)i.next();
            for (int j = 0; j < transaction.size(); ++j) {
                Geometry proposedGeometry = transaction.getGeometry(j);
                this.move(VerticesInFencePlugIn.verticesInFence(proposedGeometry, fence, false).getCoordinates(), target);
                try {
                    proposedGeometry = this.geometryEditor.removeRepeatedPoints(proposedGeometry);
                }
                catch (IllegalArgumentException e) {
                    Assert.isTrue((e.getMessage().toLowerCase().indexOf("point") > -1 && e.getMessage().toLowerCase().indexOf(">") > -1 ? 1 : 0) != 0, (String)"I assumed that we would get here only if too few points were passed into the Geometry constructor [Jon Aquino]");
                    proposedGeometry = new Point(target, proposedGeometry.getPrecisionModel(), proposedGeometry.getSRID());
                }
                transaction.setGeometry(j, proposedGeometry);
            }
            geometryChanged = geometryChanged || !this.coordinatesEqual(transaction, fence);
        }
        return geometryChanged;
    }

    private Map editableLayerToFeaturesInFenceMap(Collection editableLayers, Geometry fence, LayerViewPanel panel) {
        HashMap<Layer, Collection> editableLayerToFeaturesInFenceMap = new HashMap<Layer, Collection>();
        Iterator i = editableLayers.iterator();
        while (i.hasNext()) {
            Layer editableLayer = (Layer)i.next();
            Assert.isTrue((boolean)editableLayer.isEditable());
            editableLayerToFeaturesInFenceMap.put(editableLayer, this.featuresInFence(editableLayer, fence, panel));
        }
        return editableLayerToFeaturesInFenceMap;
    }

    private boolean coordinatesEqual(EditTransaction transaction, Geometry fence) {
        for (int i = 0; i < transaction.size(); ++i) {
            Feature originalFeature = transaction.getFeature(i);
            Geometry newGeometry = transaction.getGeometry(i);
            if (this.coordinatesEqual(VerticesInFencePlugIn.verticesInFence(originalFeature.getGeometry(), fence, true).getCoordinates(), VerticesInFencePlugIn.verticesInFence(newGeometry, fence, true).getCoordinates())) continue;
            return false;
        }
        return true;
    }

    private boolean coordinatesEqual(List a, List b) {
        if (a.size() != b.size()) {
            return false;
        }
        TreeSet A = new TreeSet(a);
        TreeSet B = new TreeSet(b);
        if (A.size() != B.size()) {
            return false;
        }
        Iterator Ai = A.iterator();
        Iterator Bi = B.iterator();
        while (Ai.hasNext()) {
            if (Ai.next().equals(Bi.next())) continue;
            return false;
        }
        return true;
    }

    private void indicateSuccess(Coordinate target, LayerViewPanel panel) throws NoninvertibleTransformException {
        Point2D center = panel.getViewport().toViewPoint(CoordUtil.toPoint2D(target));
        Animations.drawExpandingRing(center, false, Color.green, panel, null);
    }

    private void move(Collection verticesToMove, Coordinate target) {
        Iterator i = verticesToMove.iterator();
        while (i.hasNext()) {
            Coordinate vertexToMove = (Coordinate)i.next();
            vertexToMove.setCoordinate(target);
        }
    }

    private int insertVerticesIfNecessary(EditTransaction transaction, final Coordinate target, final Geometry fence) throws NoninvertibleTransformException {
        final int[] verticesInserted = new int[]{0};
        for (int i = 0; i < transaction.size(); ++i) {
            transaction.setGeometry(i, this.geometryEditor.edit(transaction.getGeometry(i), new GeometryEditor.GeometryEditorOperation(){

                public Geometry edit(Geometry geometry) {
                    if (geometry instanceof Polygon) {
                        return geometry;
                    }
                    if (geometry instanceof GeometryCollection) {
                        return geometry;
                    }
                    if (!fence.intersects(geometry)) {
                        return geometry;
                    }
                    if (!VerticesInFencePlugIn.verticesInFence(geometry, fence, true).getCoordinates().isEmpty()) {
                        return geometry;
                    }
                    verticesInserted[0] = verticesInserted[0] + 1;
                    Geometry newGeometry = SnapVerticesOp.this.geometryEditor.insertVertex(geometry, target, fence);
                    Assert.isTrue((newGeometry != null ? 1 : 0) != 0);
                    return newGeometry;
                }
            }));
        }
        return verticesInserted[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

