/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MoveVertexTool
extends DragTool {
    public static final int TOLERANCE = 5;
    private EnableCheckFactory checkFactory;

    public MoveVertexTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.setColor(new Color(194, 179, 205));
        this.setStrokeWidth(5);
        this.allowSnapping();
    }

    public Cursor getCursor() {
        return MoveVertexTool.createCursor(IconLoader.icon("MoveVertexCursor3.gif").getImage());
    }

    public Icon getIcon() {
        return IconLoader.icon("MoveVertex.gif");
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        this.moveVertices(this.getModelSource(), this.getModelDestination());
    }

    public void mousePressed(final MouseEvent e) {
        try {
            if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
                return;
            }
            if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                return;
            }
            if (!this.check(new EnableCheck(){

                public String check(JComponent component) {
                    try {
                        return !MoveVertexTool.this.nearSelectionHandle(e.getPoint()) ? "No editable selection handles here" : null;
                    }
                    catch (Exception e2) {
                        return e2.toString();
                    }
                }
            })) {
                return;
            }
            super.mousePressed(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private boolean nearSelectionHandle(Point2D p) throws NoninvertibleTransformException {
        final Envelope buffer = this.vertexBuffer(this.getPanel().getViewport().toModelCoordinate(p));
        final boolean[] result = new boolean[]{false};
        Iterator i = this.getPanel().getSelectionManager().getLayersWithSelectedItems().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (!layer.isEditable()) continue;
            Iterator j = this.getPanel().getSelectionManager().getSelectedItems(layer).iterator();
            while (j.hasNext()) {
                Geometry item = (Geometry)j.next();
                item.apply(new CoordinateFilter(){

                    public void filter(Coordinate coord) {
                        if (buffer.contains(coord)) {
                            result[0] = true;
                        }
                    }
                });
            }
        }
        return result[0];
    }

    private Envelope vertexBuffer(Coordinate c) throws NoninvertibleTransformException {
        double tolerance = 5.0 / this.getPanel().getViewport().getScale();
        return this.vertexBuffer(c, tolerance);
    }

    public void moveVertices(Coordinate initialLocation, Coordinate finalLocation) throws Exception {
        Envelope oldVertexBuffer = this.vertexBuffer(initialLocation);
        Coordinate newVertex = finalLocation;
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        Iterator i = this.getPanel().getSelectionManager().getLayersWithSelectedItems().iterator();
        while (i.hasNext()) {
            Layer layerWithSelectedItems = (Layer)i.next();
            if (!layerWithSelectedItems.isEditable()) continue;
            transactions.add(this.createTransaction(layerWithSelectedItems, oldVertexBuffer, newVertex));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, final Envelope oldVertexBuffer, final Coordinate newVertex) {
        return EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                Iterator j = selectedItems.iterator();
                while (j.hasNext()) {
                    Geometry item = (Geometry)j.next();
                    this.edit(item);
                }
                return geometryWithSelectedItems;
            }

            private void edit(Geometry selectedItem) {
                selectedItem.apply(new CoordinateFilter(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void filter(Coordinate coordinate) {
                        if (3.access$100(this.this$1).contains(coordinate)) {
                            coordinate.x = 3.access$200(this.this$1).x;
                            coordinate.y = 3.access$200(this.this$1).y;
                        }
                    }
                });
            }

            static /* synthetic */ Envelope access$100(3 x0) {
                return x0.oldVertexBuffer;
            }

            static /* synthetic */ Coordinate access$200(3 x0) {
                return x0.newVertex;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
    }

    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        double radius = 20.0;
        return new Ellipse2D.Double(destination.getX() - radius / 2.0, destination.getY() - radius / 2.0, radius, radius);
    }

    private Envelope vertexBuffer(Coordinate vertex, double tolerance) {
        return new Envelope(vertex.x - tolerance, vertex.x + tolerance, vertex.y - tolerance, vertex.y + tolerance);
    }
}

