/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class MultiClickTool
extends AbstractCursorTool {
    private List coordinates = new ArrayList();
    private Coordinate tentativeCoordinate;

    public List getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public void cancelGesture() {
        super.cancelGesture();
        this.coordinates.clear();
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if (e.getClickCount() == 1) {
                this.tentativeCoordinate = this.snap(e.getPoint());
                this.redrawShape();
            }
            super.mouseReleased(e);
            if (this.isFinishingRelease(e)) {
                this.finishGesture();
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.coordinates.isEmpty()) {
                return;
            }
            this.tentativeCoordinate = this.snap(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    protected void add(Coordinate c) {
        this.coordinates.add(c);
    }

    public void mousePressed(MouseEvent e) {
        try {
            super.mousePressed(e);
            Assert.isTrue((e.getClickCount() > 0 ? 1 : 0) != 0);
            if (e.getClickCount() != 1) {
                return;
            }
            this.add(this.snap(e.getPoint()));
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Shape getShape() throws NoninvertibleTransformException {
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint((Coordinate)this.coordinates.get(0));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        for (int i = 1; i < this.coordinates.size(); ++i) {
            Coordinate nextCoordinate = (Coordinate)this.coordinates.get(i);
            Point2D nextPoint = this.getPanel().getViewport().toViewPoint(nextCoordinate);
            path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
        }
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.tentativeCoordinate);
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        return path;
    }

    protected boolean isFinishingRelease(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    protected Coordinate[] toArray(List coordinates) {
        return coordinates.toArray(new Coordinate[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishGesture() throws Exception {
        this.clearShape();
        try {
            this.fireGestureFinished();
        }
        finally {
            this.coordinates.clear();
        }
    }
}

