/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.PartSelection;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LineStringSelection
extends AbstractSelection {
    public List items(Geometry geometry) {
        int i;
        ArrayList<Object> items = new ArrayList<Object>();
        if (geometry instanceof LineString) {
            items.add(geometry);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            items.add(polygon.getExteriorRing());
            for (i = 0; i < polygon.getNumInteriorRing(); ++i) {
                items.add(polygon.getInteriorRingN(i));
            }
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                items.addAll(this.items(geometryCollection.getGeometryN(i)));
            }
        }
        return items;
    }

    public LineStringSelection(SelectionManager selectionManager) {
        super(selectionManager);
    }

    public String getRendererContentID() {
        return "SELECTED_LINESTRINGS";
    }

    protected boolean selectedInAncestors(Layer layer, Feature feature, Geometry item) {
        Assert.isTrue((boolean)(this.getParent().getParent() instanceof FeatureSelection));
        Assert.isTrue((boolean)(this.getParent() instanceof PartSelection));
        if (this.getParent().getParent().getFeaturesWithSelectedItems().contains(feature)) {
            return true;
        }
        Iterator i = this.getParent().getSelectedItems(layer, feature).iterator();
        while (i.hasNext()) {
            Geometry selectedPart = (Geometry)i.next();
            if (!this.items(selectedPart).contains(item)) continue;
            return true;
        }
        return false;
    }

    protected void unselectInDescendants(Layer layer, Feature feature, Collection items) {
        Assert.isTrue((this.getChild() == null ? 1 : 0) != 0);
    }
}

