/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EditTransaction {
    private List features;
    private List originalGeometries;
    private List proposedGeometries;
    private Layer layer;
    private String name;
    private boolean rollingBackInvalidEdits;
    public static final String ROLLING_BACK_INVALID_EDITS_KEY = (class$com$vividsolutions$jump$workbench$ui$EditTransaction == null ? (class$com$vividsolutions$jump$workbench$ui$EditTransaction = EditTransaction.class$("com.vividsolutions.jump.workbench.ui.EditTransaction")) : class$com$vividsolutions$jump$workbench$ui$EditTransaction).getName() + " - ROLLING_BACK_INVALID_EDITS";
    private LayerViewPanelContext layerViewPanelContext;
    private GeometryEditor editor = new GeometryEditor();
    private boolean allowAddingAndRemovingFeatures;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$EditTransaction;

    public EditTransaction(Collection features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanel layerViewPanel) {
        this(features, name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanel.getContext());
    }

    public EditTransaction(Collection features, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures, LayerViewPanelContext layerViewPanelContext) {
        this.layerViewPanelContext = layerViewPanelContext;
        this.layer = layer;
        this.rollingBackInvalidEdits = rollingBackInvalidEdits;
        this.allowAddingAndRemovingFeatures = allowAddingAndRemovingFeatures;
        this.name = name;
        this.features = new ArrayList(features);
        this.originalGeometries = this.geometryClones(features);
        this.proposedGeometries = this.geometryClones(features);
    }

    public static EditTransaction createTransactionOnSelection(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, LayerViewPanelContext layerViewPanelContext, String name, Layer layer, boolean rollingBackInvalidEdits, boolean allowAddingAndRemovingFeatures) {
        Map featureToNewGeometryMap = EditTransaction.featureToNewGeometryMap(editor, selectionManagerProxy, layer);
        EditTransaction transaction = new EditTransaction(featureToNewGeometryMap.keySet(), name, layer, rollingBackInvalidEdits, allowAddingAndRemovingFeatures, layerViewPanelContext);
        transaction.setGeometries(featureToNewGeometryMap);
        return transaction;
    }

    public static Map featureToNewGeometryMap(SelectionEditor editor, SelectionManagerProxy selectionManagerProxy, Layer layer) {
        HashMap<Feature, Geometry> featureToNewGeometryMap = new HashMap<Feature, Geometry>();
        Iterator i = selectionManagerProxy.getSelectionManager().getFeaturesWithSelectedItems(layer).iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            Geometry newGeometry = (Geometry)feature.getGeometry().clone();
            ArrayList selectedItems = new ArrayList();
            Iterator j = selectionManagerProxy.getSelectionManager().getSelections().iterator();
            while (j.hasNext()) {
                AbstractSelection selection = (AbstractSelection)j.next();
                selectedItems.addAll(selection.items(newGeometry, selection.getSelectedItemIndices(layer, feature)));
            }
            newGeometry = editor.edit(newGeometry, selectedItems);
            featureToNewGeometryMap.put(feature, newGeometry);
        }
        return featureToNewGeometryMap;
    }

    public Geometry getGeometry(int i) {
        return (Geometry)this.proposedGeometries.get(i);
    }

    public Geometry getGeometry(Feature feature) {
        return this.getGeometry(this.features.indexOf(feature));
    }

    public void setGeometry(Feature feature, Geometry geometry) {
        this.setGeometry(this.features.indexOf(feature), geometry);
    }

    public void setGeometries(Map featureToGeometryMap) {
        Iterator i = featureToGeometryMap.keySet().iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            this.setGeometry(feature, (Geometry)featureToGeometryMap.get(feature));
        }
    }

    public void setGeometry(int i, Geometry geometry) {
        this.proposedGeometries.set(i, this.editor.removeRepeatedPoints(geometry));
    }

    public boolean commit() {
        return EditTransaction.commit(Collections.singleton(this));
    }

    public static boolean commit(Collection editTransactions) {
        return EditTransaction.commit(editTransactions, new SuccessAction(){

            public void run() {
            }
        });
    }

    public static boolean commit(Collection editTransactions, SuccessAction successAction) {
        if (editTransactions.isEmpty()) {
            return true;
        }
        final ArrayList<UndoableCommand> commands = new ArrayList<UndoableCommand>();
        Iterator i = editTransactions.iterator();
        while (i.hasNext()) {
            EditTransaction editTransaction = (EditTransaction)i.next();
            editTransaction.clearEnvelopeCaches();
            if (!editTransaction.proposedGeometriesValid()) {
                if (editTransaction.rollingBackInvalidEdits) {
                    editTransaction.layerViewPanelContext.warnUser("The new geometry is invalid. Cancelled.");
                    return false;
                }
                editTransaction.layerViewPanelContext.warnUser("The new geometry is invalid.");
            }
            commands.add(editTransaction.createCommand());
        }
        successAction.run();
        UndoableCommand command = new UndoableCommand(((UndoableCommand)commands.iterator().next()).getName()){

            public void execute() {
                Iterator i = commands.iterator();
                while (i.hasNext()) {
                    UndoableCommand subCommand = (UndoableCommand)i.next();
                    subCommand.execute();
                }
            }

            public void unexecute() {
                Iterator i = commands.iterator();
                while (i.hasNext()) {
                    UndoableCommand subCommand = (UndoableCommand)i.next();
                    subCommand.unexecute();
                }
            }
        };
        command.execute();
        ((EditTransaction)editTransactions.iterator().next()).layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        return true;
    }

    public boolean commit(SuccessAction successAction) {
        return EditTransaction.commit(Collections.singleton(this), successAction);
    }

    public void clearEnvelopeCaches() {
        for (int i = 0; i < this.proposedGeometries.size(); ++i) {
            Geometry proposedGeometry = (Geometry)this.proposedGeometries.get(i);
            proposedGeometry.geometryChanged();
        }
    }

    public boolean proposedGeometriesValid() {
        for (int i = 0; i < this.proposedGeometries.size(); ++i) {
            Geometry proposedGeometry = (Geometry)this.proposedGeometries.get(i);
            if (proposedGeometry.isValid()) continue;
            return false;
        }
        return true;
    }

    private UndoableCommand createCommand() {
        UndoableCommand command = new UndoableCommand(this.name){

            public void execute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.proposedGeometries, EditTransaction.this.originalGeometries, EditTransaction.this.layer);
            }

            public void unexecute() {
                EditTransaction.this.changeGeometries(EditTransaction.this.originalGeometries, EditTransaction.this.proposedGeometries, EditTransaction.this.layer);
            }
        };
        return command;
    }

    private List geometryClones(Collection features) {
        ArrayList<Object> geometryClones = new ArrayList<Object>();
        Iterator i = features.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            geometryClones.add(feature.getGeometry().clone());
        }
        return geometryClones;
    }

    private void changeGeometries(List newGeometries, List oldGeometries, Layer layer) {
        ArrayList<Feature> modifiedFeatures = new ArrayList<Feature>();
        ArrayList<Object> modifiedFeaturesOldClones = new ArrayList<Object>();
        ArrayList<Feature> featuresToAdd = new ArrayList<Feature>();
        ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
        for (int i = 0; i < this.size(); ++i) {
            Feature feature = (Feature)this.features.get(i);
            Geometry oldGeometry = (Geometry)oldGeometries.get(i);
            Geometry newGeometry = (Geometry)newGeometries.get(i);
            if (this.allowAddingAndRemovingFeatures && oldGeometry.isEmpty() && !newGeometry.isEmpty()) {
                featuresToAdd.add(feature);
                continue;
            }
            if (this.allowAddingAndRemovingFeatures && newGeometry.isEmpty() && !oldGeometry.isEmpty()) {
                featuresToRemove.add(feature);
                continue;
            }
            modifiedFeatures.add(feature);
            modifiedFeaturesOldClones.add(feature.clone());
            feature.setGeometry(newGeometry);
        }
        Layer.tryToInvalidateEnvelope(layer);
        if (!featuresToRemove.isEmpty()) {
            layer.getFeatureCollectionWrapper().removeAll(featuresToRemove);
        }
        if (!featuresToAdd.isEmpty()) {
            layer.getFeatureCollectionWrapper().addAll(featuresToAdd);
        }
        if (!modifiedFeatures.isEmpty()) {
            layer.getLayerManager().fireGeometryModified(modifiedFeatures, layer, modifiedFeaturesOldClones);
        }
    }

    public int size() {
        return this.features.size();
    }

    public Feature getFeature(int i) {
        return (Feature)this.features.get(i);
    }

    public void createFeature(Feature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        Assert.isTrue((!this.features.contains(feature) ? 1 : 0) != 0);
        this.features.add(feature);
        this.originalGeometries.add(new Point(null, null, 0));
        this.proposedGeometries.add(feature.getGeometry().clone());
    }

    public void deleteFeature(Feature feature) {
        Assert.isTrue((boolean)this.allowAddingAndRemovingFeatures);
        Assert.isTrue((!this.features.contains(feature) ? 1 : 0) != 0);
        this.features.add(feature);
        this.originalGeometries.add(feature.getGeometry().clone());
        this.proposedGeometries.add(new Point(null, null, 0));
    }

    public Layer getLayer() {
        return this.layer;
    }

    public static int emptyGeometryCount(Collection transactions) {
        int count = 0;
        Iterator i = transactions.iterator();
        while (i.hasNext()) {
            EditTransaction transaction = (EditTransaction)i.next();
            count += transaction.getEmptyGeometryCount();
        }
        return count;
    }

    private int getEmptyGeometryCount() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getGeometry(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface SuccessAction {
        public void run();
    }

    public static interface SelectionEditor {
        public Geometry edit(Geometry var1, Collection var2);
    }
}

