/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.WMService;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;

public class WMSLayer
extends AbstractLayerable
implements Cloneable {
    private String format;
    private List layerNames = new ArrayList();
    private String srs;
    private int alpha = 255;
    private WMService service;
    private Blackboard blackboard = new Blackboard();
    private String serverURL;

    public WMSLayer() {
    }

    public WMSLayer(LayerManager layerManager, String serverURL, String srs, List layerNames, String format) throws IOException {
        this(layerManager, WMSLayer.initializedService(serverURL), srs, layerNames, format);
    }

    private static WMService initializedService(String serverURL) throws IOException {
        WMService initializedService = new WMService(serverURL);
        initializedService.initialize();
        return initializedService;
    }

    public WMSLayer(LayerManager layerManager, WMService initializedService, String srs, List layerNames, String format) throws IOException {
        super((String)layerNames.get(0), layerManager);
        this.setService(initializedService);
        this.setSRS(srs);
        this.layerNames = new ArrayList(layerNames);
        this.setFormat(format);
    }

    private void setService(WMService service) {
        this.service = service;
        this.serverURL = service.getServerUrl();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public Image createImage(LayerViewPanel panel) throws IOException {
        Image image = this.createRequest(panel).getImage();
        MediaTracker mt = new MediaTracker(new JButton());
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            Assert.shouldNeverReachHere();
        }
        return image;
    }

    private BoundingBox toBoundingBox(String srs, Envelope e) {
        return new BoundingBox(srs, (float)e.getMinX(), (float)e.getMinY(), (float)e.getMaxX(), (float)e.getMaxY());
    }

    public MapRequest createRequest(LayerViewPanel panel) throws IOException {
        MapRequest request = this.getService().createMapRequest();
        request.setBoundingBox(this.toBoundingBox(this.srs, panel.getViewport().getEnvelopeInModelCoordinates()));
        request.setFormat(this.format);
        request.setImageWidth(panel.getWidth());
        request.setImageHeight(panel.getHeight());
        request.setLayers(this.layerNames);
        request.setTransparent(true);
        return request;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void addLayerName(String layerName) {
        this.layerNames.add(layerName);
    }

    public List getLayerNames() {
        return Collections.unmodifiableList(this.layerNames);
    }

    public void setSRS(String srs) {
        this.srs = srs;
    }

    public String getSRS() {
        return this.srs;
    }

    public Object clone() throws CloneNotSupportedException {
        WMSLayer clone = (WMSLayer)super.clone();
        clone.layerNames = new ArrayList(this.layerNames);
        return clone;
    }

    public void removeAllLayerNames() {
        this.layerNames.clear();
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public WMService getService() throws IOException {
        if (this.service == null) {
            Assert.isTrue((this.serverURL != null ? 1 : 0) != 0);
            this.setService(WMSLayer.initializedService(this.serverURL));
        }
        return this.service;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }
}

