/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import java.awt.Color;

public abstract class SystemLayerFinder {
    private String layerName;
    private LayerManagerProxy layerManagerProxy;

    public SystemLayerFinder(String layerName, LayerManagerProxy layerManagerProxy) {
        this.layerManagerProxy = layerManagerProxy;
        this.layerName = layerName;
    }

    public String getLayerName() {
        return this.layerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer createLayer() {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset dataset = new FeatureDataset(schema);
        Layer layer = new Layer(this.layerName, Color.blue, dataset, this.layerManagerProxy.getLayerManager()){

            public boolean isFeatureCollectionModified() {
                return false;
            }
        };
        boolean firingEvents = this.layerManagerProxy.getLayerManager().isFiringEvents();
        this.layerManagerProxy.getLayerManager().setFiringEvents(false);
        try {
            this.applyStyles(layer);
        }
        finally {
            this.layerManagerProxy.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layerManagerProxy.getLayerManager().addLayer("System", layer);
        return layer;
    }

    public Layer getLayer() {
        Layer layer = this.layerManagerProxy.getLayerManager().getLayer(this.layerName);
        if (layer == null) {
            return null;
        }
        return layer;
    }

    protected abstract void applyStyles(Layer var1);
}

