/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ObservableFeatureCollection
extends FeatureCollectionWrapper {
    private ArrayList listeners = new ArrayList();

    public ObservableFeatureCollection(FeatureCollection fc) {
        super(fc);
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void add(Feature feature) {
        super.add(feature);
        this.fireFeaturesAdded(Arrays.asList(feature));
    }

    public void remove(Feature feature) {
        super.remove(feature);
        this.fireFeaturesRemoved(Arrays.asList(feature));
    }

    private void fireFeaturesAdded(Collection features) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.featuresAdded(features);
        }
    }

    private void fireFeaturesRemoved(Collection features) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.featuresRemoved(features);
        }
    }

    public void addAll(Collection features) {
        super.addAll(features);
        this.fireFeaturesAdded(features);
    }

    public void removeAll(Collection features) {
        super.removeAll(features);
        this.fireFeaturesRemoved(features);
    }

    public Collection remove(Envelope env) {
        Collection features = super.remove(env);
        this.fireFeaturesRemoved(features);
        return features;
    }

    public static interface Listener {
        public void featuresAdded(Collection var1);

        public void featuresRemoved(Collection var1);
    }
}

