/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.ui.render.Style;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class VertexStyle
implements Style {
    private static final int size = 5;
    private double sizeOver2 = 2.5;
    protected RectangularShape shape;
    private Color color;

    public VertexStyle(Color color) {
        this.color = color;
        this.shape = new Rectangle2D.Double();
    }

    public void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D) {
        graphics2D.setPaint(this.color);
        Coordinate[] coordinateArray = geometry.getCoordinates();
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (!viewport.containsInModel(coordinateArray[i])) continue;
            Point2D point2D = viewport.toView(new Point2D.Double(coordinateArray[i].x, coordinateArray[i].y));
            this.setShape(point2D);
            graphics2D.fill(this.shape);
        }
    }

    private void setShape(Point2D point2D) {
        this.shape.setFrame(point2D.getX() - this.sizeOver2, point2D.getY() - this.sizeOver2, 5.0, 5.0);
    }
}

