/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jtstest.testbuilder.Viewport;
import com.vividsolutions.jtstest.testbuilder.java2D.Java2DConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;

public class GeometryRenderer {
    public static void paint(Geometry geometry, Viewport viewport, Graphics2D graphics2D, Color color, Color color2) {
        if (geometry instanceof GeometryCollection) {
            GeometryRenderer.paintGeometryCollection((GeometryCollection)geometry, viewport, graphics2D, color, color2);
            return;
        }
        if (geometry == null) {
            return;
        }
        Shape shape = GeometryRenderer.toShape(geometry, viewport);
        if (!(shape instanceof GeneralPath)) {
            graphics2D.setPaint(color2);
            graphics2D.fill(shape);
        }
        graphics2D.setColor(color);
        graphics2D.draw(shape);
    }

    private static void paintGeometryCollection(GeometryCollection geometryCollection, Viewport viewport, Graphics2D graphics2D, Color color, Color color2) {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            GeometryRenderer.paint(geometryCollection.getGeometryN(i), viewport, graphics2D, color, color2);
        }
    }

    private static Shape toShape(Geometry geometry, Viewport viewport) {
        try {
            Java2DConverter java2DConverter = new Java2DConverter(viewport);
            return java2DConverter.toShape(geometry);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }
}

