/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;

    public FileDrop(Component component, Listener listener) {
        this(null, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public FileDrop(Component component, boolean bl, Listener listener) {
        this(null, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), bl, listener);
    }

    public FileDrop(PrintStream printStream, Component component, Listener listener) {
        this(printStream, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public FileDrop(PrintStream printStream, Component component, boolean bl, Listener listener) {
        this(printStream, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), bl, listener);
    }

    public FileDrop(Component component, Border border, Listener listener) {
        this(null, component, border, false, listener);
    }

    public FileDrop(Component component, Border border, boolean bl, Listener listener) {
        this(null, component, border, bl, listener);
    }

    public FileDrop(PrintStream printStream, Component component, Border border, Listener listener) {
        this(printStream, component, border, false, listener);
    }

    public FileDrop(final PrintStream printStream, final Component component, final Border border, boolean bl, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    FileDrop.log(printStream, "FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(printStream, dropTargetDragEvent)) {
                        if (component instanceof JComponent) {
                            JComponent jComponent = (JComponent)component;
                            FileDrop.this.normalBorder = jComponent.getBorder();
                            FileDrop.log(printStream, "FileDrop: normal border saved.");
                            jComponent.setBorder(border);
                            FileDrop.log(printStream, "FileDrop: drag border set.");
                        }
                        dropTargetDragEvent.acceptDrag(1);
                        FileDrop.log(printStream, "FileDrop: event accepted.");
                    } else {
                        dropTargetDragEvent.rejectDrag();
                        FileDrop.log(printStream, "FileDrop: event rejected.");
                    }
                }

                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    FileDrop.log(printStream, "FileDrop: drop event.");
                    try {
                        try {
                            Transferable transferable = dropTargetDropEvent.getTransferable();
                            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                                dropTargetDropEvent.acceptDrop(1);
                                FileDrop.log(printStream, "FileDrop: file list accepted.");
                                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                                Iterator iterator = list.iterator();
                                File[] fileArray = new File[list.size()];
                                list.toArray(fileArray);
                                File[] fileArray2 = fileArray;
                                if (listener != null) {
                                    listener.filesDropped(fileArray2);
                                }
                                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                                FileDrop.log(printStream, "FileDrop: drop complete.");
                            }
                            FileDrop.log(printStream, "FileDrop: not a file list - abort.");
                            dropTargetDropEvent.rejectDrop();
                        }
                        catch (IOException iOException) {
                            FileDrop.log(printStream, "FileDrop: IOException - abort:");
                            iOException.printStackTrace(printStream);
                            dropTargetDropEvent.rejectDrop();
                            Object var8_10 = null;
                            if (!(component instanceof JComponent)) return;
                            JComponent jComponent = (JComponent)component;
                            jComponent.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(printStream, "FileDrop: normal border restored.");
                            return;
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            FileDrop.log(printStream, "FileDrop: UnsupportedFlavorException - abort:");
                            unsupportedFlavorException.printStackTrace(printStream);
                            dropTargetDropEvent.rejectDrop();
                            Object var8_11 = null;
                            if (!(component instanceof JComponent)) return;
                            JComponent jComponent = (JComponent)component;
                            jComponent.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(printStream, "FileDrop: normal border restored.");
                            return;
                        }
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (!(component instanceof JComponent)) throw throwable;
                        JComponent jComponent = (JComponent)component;
                        jComponent.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(printStream, "FileDrop: normal border restored.");
                        throw throwable;
                    }
                    if (!(component instanceof JComponent)) return;
                    JComponent jComponent = (JComponent)component;
                    jComponent.setBorder(FileDrop.this.normalBorder);
                    FileDrop.log(printStream, "FileDrop: normal border restored.");
                }

                public void dragExit(DropTargetEvent dropTargetEvent) {
                    FileDrop.log(printStream, "FileDrop: dragExit event.");
                    if (component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(printStream, "FileDrop: normal border restored.");
                    }
                }

                public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                    FileDrop.log(printStream, "FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(printStream, dropTargetDragEvent)) {
                        dropTargetDragEvent.acceptDrag(1);
                        FileDrop.log(printStream, "FileDrop: event accepted.");
                    } else {
                        dropTargetDragEvent.rejectDrag();
                        FileDrop.log(printStream, "FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(printStream, component, bl);
        } else {
            FileDrop.log(printStream, "FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean bl = false;
            try {
                Class<?> clazz = Class.forName("java.awt.dnd.DnDConstants");
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            supportsDnD = new Boolean(bl);
        }
        return supportsDnD;
    }

    private void makeDropTarget(final PrintStream printStream, final Component component, boolean bl) {
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
            FileDrop.log(printStream, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        component.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                FileDrop.log(printStream, "FileDrop: Hierarchy changed.");
                Container container = component.getParent();
                if (container == null) {
                    component.setDropTarget(null);
                    FileDrop.log(printStream, "FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(component, FileDrop.this.dropListener);
                    FileDrop.log(printStream, "FileDrop: Drop target added to component.");
                }
            }
        });
        if (component.getParent() != null) {
            new DropTarget(component, this.dropListener);
        }
        if (bl && component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.makeDropTarget(printStream, componentArray[i], bl);
            }
        }
    }

    private boolean isDragOk(PrintStream printStream, DropTargetDragEvent dropTargetDragEvent) {
        int n;
        boolean bl = false;
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        for (n = 0; !bl && n < dataFlavorArray.length; ++n) {
            if (!dataFlavorArray[n].equals(DataFlavor.javaFileListFlavor)) continue;
            bl = true;
        }
        if (printStream != null) {
            if (dataFlavorArray.length == 0) {
                FileDrop.log(printStream, "FileDrop: no data flavors.");
            }
            for (n = 0; n < dataFlavorArray.length; ++n) {
                FileDrop.log(printStream, dataFlavorArray[n].toString());
            }
        }
        return bl;
    }

    private static void log(PrintStream printStream, String string) {
        if (printStream != null) {
            printStream.println(string);
        }
    }

    public static boolean remove(Component component) {
        return FileDrop.remove(null, component, true);
    }

    public static boolean remove(PrintStream printStream, Component component, boolean bl) {
        if (FileDrop.supportsDnD()) {
            FileDrop.log(printStream, "FileDrop: Removing drag-and-drop hooks.");
            component.setDropTarget(null);
            if (bl && component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    FileDrop.remove(printStream, componentArray[i], bl);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("FileDrop");
        final JTextArea jTextArea = new JTextArea();
        jFrame.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        new FileDrop(System.out, jTextArea, new Listener(){

            public void filesDropped(File[] fileArray) {
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        jTextArea.append(fileArray[i].getCanonicalPath() + "\n");
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        jFrame.setBounds(100, 100, 300, 400);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

