/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.testbuilder.geom.VertexLocater;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;

public class GeometryLocationsWriter {
    public static String writeLocation(LayerList layerList, Coordinate coordinate, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < layerList.size(); ++i) {
            Layer layer = layerList.getLayer(i);
            String string = GeometryLocationsWriter.writeLocation(layer, coordinate, d);
            if (string == null) continue;
            if (i > 0 && stringBuffer.length() > 0) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append(layer.getName());
            stringBuffer.append(GeometryLocationsWriter.writeLocation(layer, coordinate, d));
        }
        if (stringBuffer.length() > 0) {
            return "<html>" + stringBuffer.toString() + "</html>";
        }
        return null;
    }

    public static String writeLocation(Layer layer, Coordinate coordinate, double d) {
        Geometry geometry = layer.getGeometry();
        if (geometry == null) {
            return null;
        }
        VertexLocater vertexLocater = new VertexLocater(geometry);
        Coordinate coordinate2 = vertexLocater.getVertex(coordinate, d);
        int n = vertexLocater.getIndex();
        if (coordinate2 == null) {
            return null;
        }
        return "[" + n + "]: " + coordinate2.x + ", " + coordinate2.y;
    }
}

