/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom.prep;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;

public class PreparedGeometryExample {
    static GeometryFactory geomFact = new GeometryFactory();
    static final int MAX_ITER = 100000;

    public static void main(String[] stringArray) throws Exception {
        Geometry geometry = PreparedGeometryExample.createCircle();
        PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 100000; ++i) {
            ++n;
            Point point = PreparedGeometryExample.createRandomPoint();
            if (!preparedGeometry.intersects((Geometry)point)) continue;
            ++n2;
        }
        double d = 4.0 * (double)n2 / (double)n;
        double d2 = 1.0 - d / Math.PI;
        System.out.println("Approximation to PI: " + d + "  (difference from actual = " + d2);
    }

    static Geometry createCircle() {
        Point point = geomFact.createPoint(new Coordinate(0.5, 0.5));
        return point.buffer(0.5, 20);
    }

    static Point createRandomPoint() {
        return geomFact.createPoint(new Coordinate(Math.random(), Math.random()));
    }
}

