/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.render;

import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.ui.render.RendererSwingWorker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RenderManager {
    private GeometryEditPanel panel;
    private RendererSwingWorker worker = null;
    private Image image = null;
    private boolean isDirty = true;
    private Timer repaintTimer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (RenderManager.this.worker.isRendering()) {
                RenderManager.this.paintPanel();
                return;
            }
            RenderManager.this.repaintTimer.stop();
            RenderManager.this.paintPanel();
        }
    });

    public RenderManager(GeometryEditPanel geometryEditPanel) {
        this.panel = geometryEditPanel;
        this.repaintTimer.setInitialDelay(100);
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void componentResized() {
        this.image = null;
        this.isDirty = true;
    }

    public void render() {
        if (this.image != null && !this.isDirty) {
            return;
        }
        this.isDirty = false;
        this.repaintTimer.stop();
        if (this.worker != null) {
            this.worker.cancel();
        }
        this.initImage();
        this.worker = new RendererSwingWorker(this.panel.getRenderer(), this.image);
        this.worker.start();
        this.repaintTimer.start();
    }

    private void initImage() {
        if (this.image != null) {
            this.erase(this.image);
            return;
        }
        this.image = this.createPanelImage(this.panel);
    }

    private Image createPanelImage(JPanel jPanel) {
        return new BufferedImage(jPanel.getWidth(), jPanel.getHeight(), 2);
    }

    public void erase(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setColor(Color.white);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
        graphics2D.fill(double_);
    }

    public void copyImage(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, 0, 0, null);
    }

    private void paintPanel() {
        this.copyImage(this.panel.getGraphics());
    }
}

