/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.topostretch;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.math.MathUtil;
import com.vividsolutions.jts.math.Vector2D;

public class StretchedVertex {
    private Coordinate vertexPt;
    private Coordinate[] parentLine;
    private int parentIndex;
    private Coordinate nearPt = null;
    private Coordinate[] nearPts = null;
    private int nearIndex = -1;
    private LineSegment nearSeg = null;
    private Coordinate stretchedPt = null;
    private static final double MAX_ARM_NEARNESS_ANG = 0.3490658503988659;
    private static final double POINT_LINE_FLATNESS_RATIO = 0.01;

    public StretchedVertex(Coordinate coordinate, Coordinate[] coordinateArray, int n, Coordinate coordinate2, Coordinate[] coordinateArray2, int n2) {
        this.vertexPt = coordinate;
        this.parentLine = coordinateArray;
        this.parentIndex = n;
        this.nearPt = coordinate2;
        this.nearPts = coordinateArray2;
        this.nearIndex = n2;
    }

    public StretchedVertex(Coordinate coordinate, Coordinate[] coordinateArray, int n, LineSegment lineSegment) {
        this.vertexPt = coordinate;
        this.parentLine = coordinateArray;
        this.parentIndex = n;
        this.nearSeg = lineSegment;
    }

    public Coordinate getVertexCoordinate() {
        return this.vertexPt;
    }

    public Coordinate getStretchedVertex(double d) {
        if (this.stretchedPt != null) {
            return this.stretchedPt;
        }
        this.stretchedPt = this.nearPt != null ? this.displaceFromVertex(this.nearPt, d) : this.displaceFromSeg(this.nearSeg, d);
        return this.stretchedPt;
    }

    private boolean isNearRing() {
        return CoordinateArrays.isRing((Coordinate[])this.nearPts);
    }

    private Coordinate getNearRingPoint(int n) {
        int n2 = n;
        if (n < 0) {
            n2 = n + this.nearPts.length - 1;
        } else if (n >= this.nearPts.length - 1) {
            n2 = n - (this.nearPts.length - 1);
        }
        return this.nearPts[n2];
    }

    private Coordinate displaceFromPoint(Coordinate coordinate, double d) {
        LineSegment lineSegment = new LineSegment(coordinate, this.vertexPt);
        double d2 = lineSegment.getLength();
        double d3 = (d + d2) / d2;
        Coordinate coordinate2 = lineSegment.pointAlong(d3);
        return coordinate2;
    }

    private Coordinate displaceFromSeg(LineSegment lineSegment, double d) {
        double d2 = lineSegment.projectionFactor(this.vertexPt);
        int n = lineSegment.orientationIndex(this.vertexPt);
        if (n == -1) {
            d = -d;
        }
        return lineSegment.pointAlongOffset(d2, d);
    }

    private Coordinate displaceFromVertex(Coordinate coordinate, double d) {
        if (!this.isNearRing() && this.nearIndex == 0 || this.nearIndex >= this.nearPts.length - 1) {
            return this.displaceFromPoint(coordinate, d);
        }
        Coordinate coordinate2 = this.getNearRingPoint(this.nearIndex - 1);
        Coordinate coordinate3 = this.getNearRingPoint(this.nearIndex + 1);
        if (coordinate2.equals2D(this.vertexPt) || coordinate3.equals2D(this.vertexPt)) {
            return this.displaceFromPoint(coordinate, d);
        }
        return this.displaceFromCornerAwayFromArms(coordinate, coordinate2, coordinate3, d);
    }

    private Coordinate displaceFromCornerOriginal(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        if (StretchedVertex.isFlat(coordinate, coordinate2, coordinate3)) {
            return this.displaceFromFlatCorner(coordinate, coordinate2, coordinate3, d);
        }
        Coordinate[] coordinateArray = StretchedVertex.orientCorner(coordinate, coordinate2, coordinate3);
        int n = StretchedVertex.quadrant(this.vertexPt, coordinate, coordinateArray);
        Vector2D vector2D = StretchedVertex.normalizedOffset(coordinate, coordinate2, coordinate3);
        Vector2D vector2D2 = vector2D.multiply(d);
        Vector2D vector2D3 = vector2D2.rotateByQuarterCircle(n);
        return vector2D3.translate(this.vertexPt);
    }

    private Coordinate displaceFromCorner(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        Coordinate[] coordinateArray = StretchedVertex.orientCorner(coordinate, coordinate2, coordinate3);
        Vector2D vector2D = Vector2D.create((Coordinate)coordinate, (Coordinate)coordinateArray[0]).normalize();
        Vector2D vector2D2 = Vector2D.create((Coordinate)coordinate, (Coordinate)coordinateArray[1]).normalize();
        double d2 = vector2D.angle(vector2D2);
        Vector2D vector2D3 = vector2D2.rotate(d2 / 2.0);
        Vector2D vector2D4 = vector2D3.multiply(d);
        if (!this.isInsideCorner(this.vertexPt, coordinate, coordinateArray[0], coordinateArray[1])) {
            vector2D4 = vector2D4.multiply(-1.0);
        }
        return vector2D4.translate(this.vertexPt);
    }

    private static double maxAngleToBisector(double d) {
        double d2 = d / 2.0 - 0.3490658503988659;
        if (d2 < 0.0) {
            return 0.0;
        }
        return d2;
    }

    private Coordinate displaceFromCornerAwayFromArms(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        Coordinate[] coordinateArray = StretchedVertex.orientCorner(coordinate, coordinate2, coordinate3);
        boolean bl = this.isInsideCorner(this.vertexPt, coordinate, coordinateArray[0], coordinateArray[1]);
        Vector2D vector2D = Vector2D.create((Coordinate)coordinate, (Coordinate)coordinateArray[0]).normalize();
        Vector2D vector2D2 = Vector2D.create((Coordinate)coordinate, (Coordinate)coordinateArray[1]).normalize();
        double d2 = vector2D.angle(vector2D2);
        double d3 = StretchedVertex.maxAngleToBisector(d2);
        Vector2D vector2D3 = vector2D2.rotate(d2 / 2.0);
        if (!bl) {
            vector2D3 = vector2D3.multiply(-1.0);
            double d4 = Math.PI * 2 - d2;
            d3 = StretchedVertex.maxAngleToBisector(d4);
        }
        Vector2D vector2D4 = Vector2D.create((Coordinate)coordinate, (Coordinate)this.vertexPt).normalize();
        double d5 = vector2D4.angleTo(vector2D3);
        double d6 = MathUtil.clamp((double)d5, (double)(-d3), (double)d3);
        Vector2D vector2D5 = vector2D3.rotate(-d6).multiply(d);
        return vector2D5.translate(this.vertexPt);
    }

    private boolean isInsideCorner(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        return CGAlgorithms.orientationIndex((Coordinate)coordinate2, (Coordinate)coordinate3, (Coordinate)coordinate) == -1 && CGAlgorithms.orientationIndex((Coordinate)coordinate2, (Coordinate)coordinate4, (Coordinate)coordinate) == 1;
    }

    private static boolean isFlat(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d;
        double d2 = CGAlgorithms.distancePointLine((Coordinate)coordinate, (Coordinate)coordinate2, (Coordinate)coordinate3);
        return d2 / (d = coordinate2.distance(coordinate3)) < 0.01;
    }

    private static int quadrant(Coordinate coordinate, Coordinate coordinate2, Coordinate[] coordinateArray) {
        if (CGAlgorithms.orientationIndex((Coordinate)coordinate2, (Coordinate)coordinateArray[0], (Coordinate)coordinate) == -1) {
            if (CGAlgorithms.orientationIndex((Coordinate)coordinate2, (Coordinate)coordinateArray[1], (Coordinate)coordinate) == 1) {
                return 0;
            }
            return 3;
        }
        if (CGAlgorithms.orientationIndex((Coordinate)coordinate2, (Coordinate)coordinateArray[1], (Coordinate)coordinate) == 1) {
            return 1;
        }
        return 2;
    }

    private static Coordinate rotateToQuadrant(Coordinate coordinate, int n) {
        switch (n) {
            case 0: {
                return coordinate;
            }
            case 1: {
                return new Coordinate(-coordinate.y, coordinate.x);
            }
            case 2: {
                return new Coordinate(-coordinate.x, -coordinate.y);
            }
            case 3: {
                return new Coordinate(coordinate.y, -coordinate.x);
            }
        }
        return null;
    }

    private static Coordinate[] orientCorner(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        Coordinate[] coordinateArray = -1 == CGAlgorithms.orientationIndex((Coordinate)coordinate, (Coordinate)coordinate2, (Coordinate)coordinate3) ? new Coordinate[]{coordinate2, coordinate3} : new Coordinate[]{coordinate3, coordinate2};
        return coordinateArray;
    }

    private static Vector2D normalizedOffset(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        Vector2D vector2D = Vector2D.create((Coordinate)coordinate, (Coordinate)coordinate2).normalize();
        Vector2D vector2D2 = Vector2D.create((Coordinate)coordinate, (Coordinate)coordinate3).normalize();
        Vector2D vector2D3 = vector2D.add(vector2D2).normalize();
        return vector2D3;
    }

    private Coordinate displaceFromFlatCorner(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, double d) {
        Vector2D vector2D = Vector2D.create((Coordinate)coordinate3, (Coordinate)coordinate2).rotateByQuarterCircle(1);
        Vector2D vector2D2 = vector2D.normalize().multiply(d);
        return vector2D2.translate(this.vertexPt);
    }
}

