/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AdjacentVertexFinder {
    private Geometry geom;
    private Coordinate vertexPt;
    private int vertexIndex = -1;

    public static Coordinate[] findVertices(Geometry geometry, Coordinate coordinate) {
        AdjacentVertexFinder adjacentVertexFinder = new AdjacentVertexFinder(geometry);
        return adjacentVertexFinder.getVertices(coordinate);
    }

    public AdjacentVertexFinder(Geometry geometry) {
        this.geom = geometry;
    }

    public Coordinate[] getVertices(Coordinate coordinate) {
        AdjacentVertexFilter adjacentVertexFilter = new AdjacentVertexFilter(coordinate);
        this.geom.apply((CoordinateSequenceFilter)adjacentVertexFilter);
        return adjacentVertexFilter.getVertices();
    }

    public int getIndex() {
        return this.vertexIndex;
    }

    static class AdjacentVertexFilter
    implements CoordinateSequenceFilter {
        private Coordinate basePt;
        private List adjVerts = new ArrayList();

        public AdjacentVertexFilter(Coordinate coordinate) {
            this.basePt = coordinate;
        }

        public void filter(CoordinateSequence coordinateSequence, int n) {
            Coordinate coordinate = coordinateSequence.getCoordinate(n);
            if (!coordinate.equals2D(this.basePt)) {
                return;
            }
            if (n > 0) {
                this.adjVerts.add(coordinateSequence.getCoordinate(n - 1));
            }
            if (n < coordinateSequence.size() - 1) {
                this.adjVerts.add(coordinateSequence.getCoordinate(n + 1));
            }
        }

        public Coordinate[] getVertices() {
            return CoordinateArrays.toCoordinateArray((Collection)this.adjVerts);
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

