/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderFrame;
import com.vividsolutions.jtstest.testbuilder.controller.JTSTestBuilderController;
import com.vividsolutions.jtstest.testbuilder.model.Layer;
import com.vividsolutions.jtstest.testbuilder.model.LayerList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class LayerControlList
extends JPanel {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private JTable table = new JTable(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            super.tableChanged(tableModelEvent);
            this.repaint();
        }
    };

    public void addChangeListener(final JToggleButton jToggleButton, final int n) {
        jToggleButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LayerControlList.this.enableUpdate(n, jToggleButton.isSelected());
            }
        });
    }

    public LayerControlList() {
        Object[][] objectArray = new Object[][]{{new JRadioButton(), new JCheckBox(), "A"}, {new JRadioButton(), new JCheckBox(), "B"}, {new JRadioButton(), new JCheckBox(), "Result"}};
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.setDataVector(objectArray, new Object[]{"", "", "Layer"});
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((JRadioButton)defaultTableModel.getValueAt(0, 0));
        buttonGroup.add((JRadioButton)defaultTableModel.getValueAt(1, 0));
        buttonGroup.add((JRadioButton)defaultTableModel.getValueAt(2, 0));
        this.addChangeListener((JToggleButton)defaultTableModel.getValueAt(0, 1), 0);
        this.addChangeListener((JToggleButton)defaultTableModel.getValueAt(1, 1), 1);
        this.addChangeListener((JToggleButton)defaultTableModel.getValueAt(2, 1), 2);
        this.table.setModel(defaultTableModel);
        this.table.setGridColor(SystemColor.control);
        this.table.setBackground(SystemColor.control);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new RadioButtonRenderer());
        this.table.getColumnModel().getColumn(0).setCellEditor(new RadioButtonEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new CheckBoxRenderer());
        this.table.getColumnModel().getColumn(1).setCellEditor(new CheckBoxEditor(new JCheckBox()));
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getColumnModel().getColumn(2).setMaxWidth(120);
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "Center");
    }

    public void populateList() {
    }

    private void enableUpdate(int n, boolean bl) {
        LayerList layerList = JTSTestBuilderFrame.instance().getModel().getLayers();
        Layer layer = layerList.getLayer(n);
        layer.setEnabled(bl);
        this.repaint();
        JTSTestBuilderController.geometryViewChanged();
    }

    class CheckBoxEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JCheckBox button;

        public CheckBoxEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            this.button = (JCheckBox)object;
            this.button.addItemListener(this);
            return (Component)object;
        }

        public Object getCellEditorValue() {
            this.button.removeItemListener(this);
            return this.button;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            super.fireEditingStopped();
        }
    }

    class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton button;

        public RadioButtonEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            this.button = (JRadioButton)object;
            this.button.addItemListener(this);
            return (Component)object;
        }

        public Object getCellEditorValue() {
            this.button.removeItemListener(this);
            return this.button;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            super.fireEditingStopped();
        }
    }

    class CheckBoxRenderer
    implements TableCellRenderer {
        CheckBoxRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return null;
            }
            return (Component)object;
        }
    }

    class RadioButtonRenderer
    implements TableCellRenderer {
        RadioButtonRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return null;
            }
            return (Component)object;
        }
    }
}

