/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.clean.CleanDuplicatePoints;
import com.vividsolutions.jtstest.clean.LineStringExtracter;
import com.vividsolutions.jtstest.testbuilder.AppCursors;
import com.vividsolutions.jtstest.testbuilder.GeometryEditPanel;
import com.vividsolutions.jtstest.testbuilder.GeometryInspectorDialog;
import com.vividsolutions.jtstest.testbuilder.InfoPanel;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderMenuBar;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilderToolBar;
import com.vividsolutions.jtstest.testbuilder.JTSTestBuilder_AboutBox;
import com.vividsolutions.jtstest.testbuilder.LayerListPanel;
import com.vividsolutions.jtstest.testbuilder.PrecisionModelDialog;
import com.vividsolutions.jtstest.testbuilder.ResultValuePanel;
import com.vividsolutions.jtstest.testbuilder.ResultWKTPanel;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelEvent;
import com.vividsolutions.jtstest.testbuilder.SpatialFunctionPanelListener;
import com.vividsolutions.jtstest.testbuilder.StatsPanel;
import com.vividsolutions.jtstest.testbuilder.TestCasePanel;
import com.vividsolutions.jtstest.testbuilder.TestCaseTextDialog;
import com.vividsolutions.jtstest.testbuilder.TestListPanel;
import com.vividsolutions.jtstest.testbuilder.TextViewDialog;
import com.vividsolutions.jtstest.testbuilder.WKTPanel;
import com.vividsolutions.jtstest.testbuilder.controller.JTSTestBuilderController;
import com.vividsolutions.jtstest.testbuilder.controller.ResultController;
import com.vividsolutions.jtstest.testbuilder.model.GeometryEvent;
import com.vividsolutions.jtstest.testbuilder.model.GeometryListener;
import com.vividsolutions.jtstest.testbuilder.model.HtmlWriter;
import com.vividsolutions.jtstest.testbuilder.model.JavaTestWriter;
import com.vividsolutions.jtstest.testbuilder.model.TestBuilderModel;
import com.vividsolutions.jtstest.testbuilder.model.TestCaseEdit;
import com.vividsolutions.jtstest.testbuilder.model.XMLTestWriter;
import com.vividsolutions.jtstest.testbuilder.ui.ImageUtil;
import com.vividsolutions.jtstest.testbuilder.ui.SwingUtil;
import com.vividsolutions.jtstest.testbuilder.ui.dnd.FileDrop;
import com.vividsolutions.jtstest.testbuilder.ui.tools.DeleteVertexTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.EditVertexTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.ExtractComponentTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.InfoTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.LineStringTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.PanTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.PointTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.RectangleTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.StreamPolygonTool;
import com.vividsolutions.jtstest.testbuilder.ui.tools.ZoomToClickTool;
import com.vividsolutions.jtstest.testrunner.GuiUtil;
import com.vividsolutions.jtstest.util.FileUtil;
import com.vividsolutions.jtstest.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTSTestBuilderFrame
extends JFrame {
    private static JTSTestBuilderFrame singleton = null;
    private ResultController resultController = new ResultController(this);
    private JTSTestBuilderMenuBar tbMenuBar = new JTSTestBuilderMenuBar(this);
    private JTSTestBuilderToolBar tbToolBar = new JTSTestBuilderToolBar(this);
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    Border border4;
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    TestCasePanel testCasePanel = new TestCasePanel();
    JPanel jPanel2 = new JPanel();
    JTabbedPane inputTabbedPane = new JTabbedPane();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel testPanel = new JPanel();
    WKTPanel wktPanel = new WKTPanel();
    TestListPanel testListPanel = new TestListPanel(this);
    LayerListPanel layerListPanel = new LayerListPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridLayout gridLayout1 = new GridLayout();
    ResultWKTPanel resultWKTPanel = new ResultWKTPanel();
    ResultValuePanel resultValuePanel = new ResultValuePanel();
    StatsPanel statsPanel = new StatsPanel();
    InfoPanel logPanel = new InfoPanel();
    private ZoomToClickTool zoomInTool;
    private final ImageIcon appIcon = new ImageIcon(this.getClass().getResource("app-icon.gif"));
    private JFileChooser fileChooser = new JFileChooser();
    private JFileChooser pngFileChooser;
    private JFileChooser fileAndDirectoryChooser = new JFileChooser();
    private JFileChooser directoryChooser = new JFileChooser();
    TestBuilderModel tbModel;
    private TextViewDialog textViewDlg = new TextViewDialog(this, "", true);
    private TestCaseTextDialog testCaseTextDlg = new TestCaseTextDialog(this, "", true);
    private GeometryInspectorDialog geomInspectorDlg = new GeometryInspectorDialog(this);

    public JTSTestBuilderFrame() {
        try {
            Assert.isTrue((singleton == null ? 1 : 0) != 0);
            singleton = this;
            this.enableEvents(64L);
            this.setIconImage(this.appIcon.getImage());
            this.jbInit();
            this.testCasePanel.spatialFunctionPanel.addSpatialFunctionPanelListener(new SpatialFunctionPanelListener(){

                public void functionExecuted(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
                    JTSTestBuilderFrame.this.resultController.spatialFunctionPanel_functionExecuted(spatialFunctionPanelEvent);
                }
            });
            this.testCasePanel.scalarFunctionPanel.addSpatialFunctionPanelListener(new SpatialFunctionPanelListener(){

                public void functionExecuted(SpatialFunctionPanelEvent spatialFunctionPanelEvent) {
                    JTSTestBuilderFrame.this.resultController.scalarFunctionPanel_functionExecuted(spatialFunctionPanelEvent);
                }
            });
            this.testCasePanel.editCtlPanel.btnSetPrecisionModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTSTestBuilderFrame.this.precisionModelMenuItem_actionPerformed(actionEvent);
                }
            });
            this.testCasePanel.editCtlPanel.cbMagnifyTopo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTSTestBuilderFrame.this.revealTopo_actionPerformed();
                }
            });
            this.testCasePanel.editCtlPanel.stretchDist.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JTSTestBuilderFrame.this.revealTopo_actionPerformed();
                }
            });
            this.zoomInTool = new ZoomToClickTool(2.0, AppCursors.ZOOM);
            this.showGeomsTab();
            this.initFileDrop(this.testCasePanel);
            this.testCasePanel.getGeometryEditPanel().setCurrentTool(RectangleTool.getInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initFileDrop(Component component) {
        new FileDrop(component, new FileDrop.Listener(){

            public void filesDropped(File[] fileArray) {
                try {
                    JTSTestBuilderFrame.this.openXmlFilesAndDirectories(fileArray);
                }
                catch (Exception exception) {
                    SwingUtil.reportException(null, exception);
                }
            }
        });
    }

    private void initFileChoosers() {
        if (this.pngFileChooser == null) {
            this.pngFileChooser = new JFileChooser();
            this.pngFileChooser.addChoosableFileFilter(SwingUtil.PNG_FILE_FILTER);
            this.pngFileChooser.setDialogTitle("Save PNG");
            this.pngFileChooser.setSelectedFile(new File("geoms.png"));
        }
    }

    public static JTSTestBuilderFrame instance() {
        if (singleton == null) {
            new JTSTestBuilderFrame();
        }
        return singleton;
    }

    public static GeometryEditPanel getGeometryEditPanel() {
        return JTSTestBuilderFrame.instance().getTestCasePanel().getGeometryEditPanel();
    }

    public TestBuilderModel getModel() {
        return this.tbModel;
    }

    public void setModel(TestBuilderModel testBuilderModel) {
        this.tbModel = testBuilderModel;
        this.testCasePanel.setModel(this.tbModel);
        this.wktPanel.setModel(testBuilderModel);
        this.resultWKTPanel.setModel(testBuilderModel);
        this.resultValuePanel.setModel(testBuilderModel);
        this.statsPanel.setModel(testBuilderModel);
        testBuilderModel.getGeometryEditModel().addGeometryListener(new GeometryListener(){

            public void geometryChanged(GeometryEvent geometryEvent) {
                JTSTestBuilderFrame.this.model_geometryChanged(geometryEvent);
            }
        });
        this.testListPanel.populateList();
        this.layerListPanel.populateList();
        this.updateTestCaseView();
        this.updatePrecisionModelDescription();
    }

    public static void reportException(Exception exception) {
        SwingUtil.reportException(JTSTestBuilderFrame.instance(), exception);
    }

    public void setCurrentTestCase(TestCaseEdit testCaseEdit) {
        this.tbModel.setCurrentTestCase(testCaseEdit);
        this.updateTestCaseView();
    }

    public TestCasePanel getTestCasePanel() {
        return this.testCasePanel;
    }

    public ResultWKTPanel getResultWKTPanel() {
        return this.resultWKTPanel;
    }

    public ResultValuePanel getResultValuePanel() {
        return this.resultValuePanel;
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        JTSTestBuilder_AboutBox jTSTestBuilder_AboutBox = new JTSTestBuilder_AboutBox(this);
        Dimension dimension = jTSTestBuilder_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        jTSTestBuilder_AboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        jTSTestBuilder_AboutBox.setModal(true);
        jTSTestBuilder_AboutBox.setVisible(true);
    }

    public void showGeomsTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Input"));
    }

    public void showResultWKTTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Result"));
    }

    public void showResultValueTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Value"));
    }

    public void showInfoTab() {
        this.inputTabbedPane.setSelectedIndex(this.inputTabbedPane.indexOfTab("Log"));
    }

    public void openXmlFilesAndDirectories(File[] fileArray) throws Exception {
        if (fileArray.length == 1) {
            this.fileChooser.setSelectedFile(fileArray[0]);
        }
        this.tbModel.openXmlFilesAndDirectories(fileArray);
        this.reportProblemsParsingXmlTestFile(this.tbModel.getParsingProblems());
        this.updateTestCaseView();
        this.testListPanel.populateList();
        this.updatePrecisionModelDescription();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void model_geometryChanged(GeometryEvent geometryEvent) {
        JTSTestBuilderController.geometryViewChanged();
        this.updateWktPanel();
    }

    void btnNewCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.createNew();
        this.showGeomsTab();
        this.updateTestCases();
    }

    void btnPrevCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.prevCase();
        this.updateTestCaseView();
    }

    void btnNextCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.nextCase();
        this.updateTestCaseView();
    }

    void btnCopyCase_actionPerformed() {
        this.tbModel.copyCase();
        this.updateTestCases();
    }

    public void updateTestCases() {
        this.testListPanel.populateList();
        this.updateTestCaseView();
    }

    public void copyResultToTest() {
        Object object = this.tbModel.getResult();
        if (!(object instanceof Geometry)) {
            return;
        }
        this.tbModel.addCase(new Geometry[]{(Geometry)object, null}, "Result of " + this.tbModel.getOpName());
        this.updateTestCaseView();
        this.testListPanel.populateList();
    }

    void btnExchangeGeoms_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.getCurrentTestCaseEdit().exchange();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
    }

    void btnDeleteCase_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.deleteCase();
        this.updateTestCaseView();
        this.testListPanel.populateList();
    }

    void menuExchangeGeom_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.getCurrentTestCaseEdit().exchange();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
    }

    void menuViewText_actionPerformed(ActionEvent actionEvent) {
        this.testCaseTextDlg.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.testCaseTextDlg.setVisible(true);
    }

    void actionInspectGeometry() {
        int n = this.tbModel.getGeometryEditModel().getGeomIndex();
        this.geomInspectorDlg.setGeometry(n == 0 ? "A" : "B", this.tbModel.getCurrentTestCaseEdit().getGeometry(n));
        this.geomInspectorDlg.setVisible(true);
    }

    void menuLoadXmlTestFile_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(SwingUtil.JAVA_FILE_FILTER);
            this.fileChooser.addChoosableFileFilter(SwingUtil.XML_FILE_FILTER);
            this.fileChooser.setDialogTitle("Open XML Test File(s)");
            this.fileChooser.setMultiSelectionEnabled(true);
            if (0 == this.fileChooser.showOpenDialog(this)) {
                File[] fileArray = this.fileChooser.getSelectedFiles();
                if (fileArray.length == 0) {
                    fileArray = new File[]{this.fileChooser.getSelectedFile()};
                }
                this.openXmlFilesAndDirectories(fileArray);
            }
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    void menuSaveAsXml_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(SwingUtil.JAVA_FILE_FILTER);
            this.fileChooser.addChoosableFileFilter(SwingUtil.XML_FILE_FILTER);
            this.fileChooser.setDialogTitle("Save XML Test File");
            if (0 == this.fileChooser.showSaveDialog(this)) {
                File file = this.fileChooser.getSelectedFile();
                if (!SwingUtil.confirmOverwrite(this, file)) {
                    return;
                }
                FileUtil.setContents(this.fileChooser.getSelectedFile().getPath(), XMLTestWriter.getRunXml(this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel()));
            }
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    public String getRunXml() {
        return XMLTestWriter.getRunXml(this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel());
    }

    void menuSaveAsJava_actionPerformed(ActionEvent actionEvent) {
        try {
            this.fileChooser.removeChoosableFileFilter(SwingUtil.XML_FILE_FILTER);
            this.fileChooser.addChoosableFileFilter(SwingUtil.JAVA_FILE_FILTER);
            this.fileChooser.setDialogTitle("Save Java File");
            if (0 == this.fileChooser.showSaveDialog(this)) {
                File file = this.fileChooser.getSelectedFile();
                if (!SwingUtil.confirmOverwrite(this, file)) {
                    return;
                }
                String string = this.fileChooser.getSelectedFile().getName();
                int n = string.lastIndexOf(".");
                if (n > 0) {
                    string = string.substring(0, n);
                }
                FileUtil.setContents(this.fileChooser.getSelectedFile().getPath(), JavaTestWriter.getRunJava(string, this.tbModel));
            }
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    void menuSaveAsHtml_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.setDialogTitle("Select Folder In Which To Save HTML and GIF Files");
            if (0 == this.directoryChooser.showSaveDialog(this)) {
                int n = JOptionPane.showConfirmDialog(this, "Would you like the spatial function images to show the A and B geometries?", "Confirmation", 1);
                HtmlWriter htmlWriter = new HtmlWriter();
                switch (n) {
                    case 2: {
                        return;
                    }
                    case 0: {
                        htmlWriter.setShowingABwithSpatialFunction(true);
                        break;
                    }
                    case 1: {
                        htmlWriter.setShowingABwithSpatialFunction(false);
                    }
                }
                File file = this.directoryChooser.getSelectedFile();
                Assert.isTrue((boolean)file.exists());
                htmlWriter.write(file, this.tbModel.getTestCaseList(), this.tbModel.getPrecisionModel());
            }
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    void menuSaveAsPNG_actionPerformed(ActionEvent actionEvent) {
        this.initFileChoosers();
        try {
            String string = SwingUtil.chooseFilenameWithConfirm(this, this.pngFileChooser);
            if (string == null) {
                return;
            }
            ImageUtil.writeImage(this.testCasePanel.getGeometryEditPanel(), string, ImageUtil.IMAGE_FORMAT_NAME_PNG);
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    void menuSaveScreenToClipboard_actionPerformed(ActionEvent actionEvent) {
        try {
            ImageUtil.saveImageToClipboard(this.testCasePanel.getGeometryEditPanel(), ImageUtil.IMAGE_FORMAT_NAME_PNG);
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    void drawRectangleButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(RectangleTool.getInstance());
    }

    void drawPolygonButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(StreamPolygonTool.getInstance());
    }

    void drawLineStringButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(LineStringTool.getInstance());
    }

    void drawPointButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(PointTool.getInstance());
    }

    void infoButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(InfoTool.getInstance());
    }

    void actionExtractComponentButton() {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(ExtractComponentTool.getInstance());
    }

    void actionDeleteVertexButton() {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(DeleteVertexTool.getInstance());
    }

    void zoomInButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(this.zoomInTool);
    }

    void oneToOneButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().getViewport().zoomToInitialExtent();
    }

    void zoomToFullExtentButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToFullExtent();
    }

    void zoomToResult_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToResult();
    }

    void zoomToInputButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToInput();
    }

    void zoomToInputA_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToGeometry(0);
    }

    void zoomToInputB_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().zoomToGeometry(1);
    }

    void panButton_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(PanTool.getInstance());
    }

    void deleteAllTestCasesMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.tbModel.initTestCaseList();
        this.updateTestCaseView();
        this.testListPanel.populateList();
    }

    public void setShowingGrid(boolean bl) {
        this.testCasePanel.editPanel.setGridEnabled(bl);
        JTSTestBuilderController.geometryViewChanged();
    }

    public void setShowingStructure(boolean bl) {
        TestBuilderModel.setShowingStructure(bl);
        JTSTestBuilderController.geometryViewChanged();
    }

    public void setShowingOrientations(boolean bl) {
        TestBuilderModel.setShowingOrientation(bl);
        JTSTestBuilderController.geometryViewChanged();
    }

    public void setShowVertexIndices(boolean bl) {
        TestBuilderModel.setShowingOrientation(bl);
        JTSTestBuilderController.geometryViewChanged();
    }

    public void setShowingVertices(boolean bl) {
        TestBuilderModel.setShowingVertices(bl);
        JTSTestBuilderController.geometryViewChanged();
    }

    void showVertexIndicesMenuItem_actionPerformed(ActionEvent actionEvent) {
    }

    void menuLoadXmlTestFolder_actionPerformed(ActionEvent actionEvent) {
        try {
            this.directoryChooser.removeChoosableFileFilter(SwingUtil.JAVA_FILE_FILTER);
            this.directoryChooser.setDialogTitle("Open Folder(s) Containing XML Test Files");
            this.directoryChooser.setMultiSelectionEnabled(true);
            if (0 == this.directoryChooser.showOpenDialog(this)) {
                File[] fileArray = this.directoryChooser.getSelectedFiles();
                if (fileArray.length == 0) {
                    fileArray = new File[]{this.fileChooser.getSelectedFile()};
                }
                this.openXmlFilesAndDirectories(fileArray);
            }
        }
        catch (Exception exception) {
            SwingUtil.reportException(this, exception);
        }
    }

    void precisionModelMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            PrecisionModelDialog precisionModelDialog = new PrecisionModelDialog(this, "Edit Precision Model", true);
            GuiUtil.center(precisionModelDialog, this);
            precisionModelDialog.setPrecisionModel(this.tbModel.getPrecisionModel());
            precisionModelDialog.setVisible(true);
            this.tbModel.changePrecisionModel(precisionModelDialog.getPrecisionModel());
            this.updatePrecisionModelDescription();
            this.updateGeometry();
        }
        catch (ParseException parseException) {
            SwingUtil.reportException(this, (Exception)((Object)parseException));
        }
    }

    void revealTopo_actionPerformed() {
        this.tbModel.setMagnifyingTopology(this.testCasePanel.editCtlPanel.cbMagnifyTopo.isSelected());
        this.tbModel.setTopologyStretchSize(this.testCasePanel.editCtlPanel.getStretchSize());
        JTSTestBuilderController.geometryViewChanged();
    }

    private void jbInit() throws Exception {
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileAndDirectoryChooser.setFileSelectionMode(2);
        this.fileAndDirectoryChooser.setMultiSelectionEnabled(true);
        this.directoryChooser.setFileSelectionMode(1);
        this.directoryChooser.setMultiSelectionEnabled(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.textViewDlg.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.textViewDlg.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.contentPane = (JPanel)this.getContentPane();
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(93, 93, 93), new Color(134, 134, 134));
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(800, 800));
        this.setTitle("JTS TestBuilder");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setPreferredSize(new Dimension(601, 690));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setMinimumSize(new Dimension(431, 0));
        this.contentPane.setPreferredSize(new Dimension(601, 690));
        this.inputTabbedPane.setTabPlacement(2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.wktPanel.setMinimumSize(new Dimension(111, 0));
        this.wktPanel.setPreferredSize(new Dimension(600, 100));
        this.wktPanel.setToolTipText("Enter WKT, WKB or GML for a geometry; or drag-n-drop a WKT or SHP file");
        this.testPanel.setLayout(this.gridBagLayout2);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(1);
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "top");
        this.jPanel1.add((Component)this.testCasePanel, "Center");
        this.jSplitPane1.add((Component)this.jPanel2, "bottom");
        this.jPanel2.add((Component)this.inputTabbedPane, "Center");
        this.jSplitPane1.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.jSplitPane1.setResizeWeight(0.5);
        this.inputTabbedPane.add((Component)this.testListPanel, "Cases");
        this.inputTabbedPane.add((Component)this.wktPanel, "Input");
        this.inputTabbedPane.add((Component)this.resultWKTPanel, "Result");
        this.inputTabbedPane.add((Component)this.resultValuePanel, "Value");
        this.inputTabbedPane.add((Component)this.statsPanel, "Stats");
        this.inputTabbedPane.add((Component)this.logPanel, "Log");
        this.inputTabbedPane.add((Component)this.layerListPanel, "Layers");
        this.inputTabbedPane.setSelectedIndex(1);
        this.inputTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTSTestBuilderFrame.this.updateStatsPanelIfVisible();
            }
        });
        this.jSplitPane1.setDividerLocation(500);
        this.setJMenuBar(this.tbMenuBar.getMenuBar());
        this.contentPane.add((Component)this.tbToolBar.getToolBar(), "North");
    }

    private void updateStatsPanelIfVisible() {
        int n = this.inputTabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (this.inputTabbedPane.getComponent(n) == this.statsPanel) {
            this.statsPanel.refresh();
        }
    }

    private void updateGeometry() {
        this.testCasePanel.relatePanel.clearResults();
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.updateWktPanel();
    }

    private void updateWktPanel() {
        Geometry geometry = this.tbModel.getGeometryEditModel().getGeometry(0);
        this.wktPanel.setText(geometry, 0);
        Geometry geometry2 = this.tbModel.getGeometryEditModel().getGeometry(1);
        this.wktPanel.setText(geometry2, 1);
    }

    private void updatePrecisionModelDescription() {
        this.testCasePanel.setPrecisionModelDescription(this.tbModel.getPrecisionModel().toString());
    }

    public void updateTestCaseView() {
        this.testCasePanel.setTestCase(this.tbModel.getCurrentTestCaseEdit());
        this.getTestCasePanel().setCurrentTestCaseIndex(this.tbModel.getCurrentTestIndex() + 1);
        this.getTestCasePanel().setMaxTestCaseIndex(this.tbModel.getTestListSize());
        this.updateWktPanel();
        this.updateStatsPanelIfVisible();
    }

    public void displayInfo(Coordinate coordinate) {
        this.displayInfo(this.testCasePanel.getGeometryEditPanel().getInfo(coordinate));
    }

    public void displayInfo(String string) {
        this.displayInfo(string, true);
    }

    public void displayInfo(String string, boolean bl) {
        this.logPanel.addInfo(string);
        if (bl) {
            this.showInfoTab();
        }
    }

    private void reportProblemsParsingXmlTestFile(List list) {
        if (list.isEmpty()) {
            return;
        }
        for (String string : list) {
            System.out.println(string);
        }
        JOptionPane.showMessageDialog(this, StringUtil.wrap(list.size() + " problems occurred parsing the XML test file." + " The first problem was: " + list.get(0), 80), "Error", 0);
    }

    void menuRemoveDuplicatePoints_actionPerformed(ActionEvent actionEvent) {
        CleanDuplicatePoints cleanDuplicatePoints = new CleanDuplicatePoints();
        Geometry geometry = cleanDuplicatePoints.clean(this.tbModel.getCurrentTestCaseEdit().getGeometry(0));
        this.tbModel.getCurrentTestCaseEdit().setGeometry(0, geometry);
        this.updateGeometry();
    }

    void menuChangeToLines_actionPerformed(ActionEvent actionEvent) {
        LineStringExtracter lineStringExtracter = new LineStringExtracter();
        Geometry geometry = lineStringExtracter.extract(this.tbModel.getCurrentTestCaseEdit().getGeometry(0));
        this.tbModel.getCurrentTestCaseEdit().setGeometry(0, geometry);
        this.updateGeometry();
    }

    void btnEditVertex_actionPerformed(ActionEvent actionEvent) {
        this.testCasePanel.getGeometryEditPanel().setCurrentTool(EditVertexTool.getInstance());
    }

    private Coordinate pickOffset(Geometry geometry, Geometry geometry2) {
        if (geometry != null && !geometry.isEmpty()) {
            return geometry.getCoordinates()[0];
        }
        if (geometry2 != null && !geometry2.isEmpty()) {
            return geometry2.getCoordinates()[0];
        }
        return null;
    }
}

