/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jtstest.testbuilder.GeometricObjectNode;
import com.vividsolutions.jtstest.testbuilder.GeometryCollectionNode;
import com.vividsolutions.jtstest.testbuilder.LineStringNode;
import com.vividsolutions.jtstest.testbuilder.LinearRingNode;
import com.vividsolutions.jtstest.testbuilder.PointNode;
import com.vividsolutions.jtstest.testbuilder.PolygonNode;
import java.util.ArrayList;
import java.util.List;

abstract class GeometryNode
extends GeometricObjectNode {
    private boolean isLeaf;
    protected List<GeometricObjectNode> children = null;

    public static GeometryNode create(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            return new GeometryCollectionNode((GeometryCollection)geometry);
        }
        if (geometry instanceof Polygon) {
            return new PolygonNode((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return new LineStringNode((LineString)geometry);
        }
        if (geometry instanceof LinearRing) {
            return new LinearRingNode((LinearRing)geometry);
        }
        if (geometry instanceof Point) {
            return new PointNode((Point)geometry);
        }
        return null;
    }

    public GeometryNode(Geometry geometry) {
        this(geometry, 0, null);
    }

    public GeometryNode(Geometry geometry, int n, String string) {
        super(GeometryNode.geometryText(geometry, n, string));
        if (geometry.isEmpty()) {
            this.isLeaf = true;
        }
    }

    private static String geometryText(Geometry geometry, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            stringBuilder.append(string + " : ");
        }
        stringBuilder.append(geometry.getGeometryType());
        if (geometry.isEmpty()) {
            stringBuilder.append(" EMPTY");
        } else if (n > 0) {
            stringBuilder.append(" " + GeometryNode.sizeString(n));
        }
        stringBuilder.append(" --     Len: " + geometry.getLength());
        if (geometry.getDimension() >= 2) {
            stringBuilder.append("      Area: " + geometry.getArea());
        }
        return stringBuilder.toString();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public GeometricObjectNode getChildAt(int n) {
        if (this.isLeaf) {
            return null;
        }
        this.populateChildren();
        return this.children.get(n);
    }

    public int getChildCount() {
        if (this.isLeaf) {
            return 0;
        }
        this.populateChildren();
        return this.children.size();
    }

    public int getIndexOfChild(GeometricObjectNode geometricObjectNode) {
        if (this.isLeaf) {
            return -1;
        }
        this.populateChildren();
        return this.children.indexOf(geometricObjectNode);
    }

    private void populateChildren() {
        if (this.children != null) {
            return;
        }
        this.children = new ArrayList<GeometricObjectNode>();
        this.fillChildren();
    }

    protected abstract void fillChildren();
}

