/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jtstest.testbuilder.GeometricObjectNode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

class CoordinateNode
extends GeometricObjectNode {
    private static DecimalFormat fmt = new DecimalFormat("0.#################", new DecimalFormatSymbols());
    Coordinate coord;

    public static CoordinateNode create(Coordinate coordinate) {
        return new CoordinateNode(coordinate);
    }

    public static CoordinateNode create(Coordinate coordinate, int n, double d) {
        return new CoordinateNode(coordinate, n, d);
    }

    private static String label(Coordinate coordinate, int n, double d) {
        String string = fmt.format(coordinate.x) + "   " + fmt.format(coordinate.y);
        if (!Double.isNaN(d)) {
            string = string + "  --  dist: " + d;
        }
        return string;
    }

    public CoordinateNode(Coordinate coordinate) {
        this(coordinate, 0, Double.NaN);
    }

    public CoordinateNode(Coordinate coordinate, int n, double d) {
        super(CoordinateNode.label(coordinate, n, d));
        this.coord = coordinate;
        this.index = n;
    }

    public Geometry getGeometry() {
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPoint(this.coord);
    }

    public boolean isLeaf() {
        return true;
    }

    public GeometricObjectNode getChildAt(int n) {
        throw new IllegalStateException("should not be here");
    }

    public int getChildCount() {
        return 0;
    }

    public int getIndexOfChild(GeometricObjectNode geometricObjectNode) {
        throw new IllegalStateException("should not be here");
    }
}

