/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortingFunctions {
    public static Geometry sortByLength(Geometry geometry) {
        List list = SortingFunctions.components(geometry);
        Collections.sort(list, new GeometryLengthComparator());
        return geometry.getFactory().buildGeometry((Collection)list);
    }

    public static Geometry sortByArea(Geometry geometry) {
        List list = SortingFunctions.components(geometry);
        Collections.sort(list, new GeometryAreaComparator());
        return geometry.getFactory().buildGeometry((Collection)list);
    }

    private static List components(Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            arrayList.add(geometry.getGeometryN(i));
        }
        return arrayList;
    }

    private static class GeometryAreaComparator
    implements Comparator {
        private GeometryAreaComparator() {
        }

        public int compare(Object object, Object object2) {
            Geometry geometry = (Geometry)object;
            Geometry geometry2 = (Geometry)object2;
            return Double.compare(geometry.getArea(), geometry2.getArea());
        }
    }

    private static class GeometryLengthComparator
    implements Comparator {
        private GeometryLengthComparator() {
        }

        public int compare(Object object, Object object2) {
            Geometry geometry = (Geometry)object;
            Geometry geometry2 = (Geometry)object2;
            return Double.compare(geometry.getLength(), geometry2.getLength());
        }
    }
}

