/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jtstest.function.AffineTransformationFunctions;
import com.vividsolutions.jtstest.function.BufferByUnionFunctions;
import com.vividsolutions.jtstest.function.BufferFunctions;
import com.vividsolutions.jtstest.function.CGAlgorithmFunctions;
import com.vividsolutions.jtstest.function.ConstructionFunctions;
import com.vividsolutions.jtstest.function.ConversionFunctions;
import com.vividsolutions.jtstest.function.CreateFractalShapeFunctions;
import com.vividsolutions.jtstest.function.CreateRandomShapeFunctions;
import com.vividsolutions.jtstest.function.CreateShapeFunctions;
import com.vividsolutions.jtstest.function.DistanceFunctions;
import com.vividsolutions.jtstest.function.DoubleKeyMap;
import com.vividsolutions.jtstest.function.GeometryFunction;
import com.vividsolutions.jtstest.function.GeometryFunctions;
import com.vividsolutions.jtstest.function.JTSFunctions;
import com.vividsolutions.jtstest.function.LineHandlingFunctions;
import com.vividsolutions.jtstest.function.LinearReferencingFunctions;
import com.vividsolutions.jtstest.function.NodingFunctions;
import com.vividsolutions.jtstest.function.OffsetCurveFunctions;
import com.vividsolutions.jtstest.function.OverlayFunctions;
import com.vividsolutions.jtstest.function.OverlayNoSnapFunctions;
import com.vividsolutions.jtstest.function.PolygonOverlayFunctions;
import com.vividsolutions.jtstest.function.PolygonizeFunctions;
import com.vividsolutions.jtstest.function.PrecisionFunctions;
import com.vividsolutions.jtstest.function.PreparedGeometryFunctions;
import com.vividsolutions.jtstest.function.SelectionFunctions;
import com.vividsolutions.jtstest.function.SimplificationFunctions;
import com.vividsolutions.jtstest.function.SnappingFunctions;
import com.vividsolutions.jtstest.function.SortingFunctions;
import com.vividsolutions.jtstest.function.StaticMethodGeometryFunction;
import com.vividsolutions.jtstest.function.TriangleFunctions;
import com.vividsolutions.jtstest.function.TriangulationFunctions;
import com.vividsolutions.jtstest.function.ValidationFunctions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GeometryFunctionRegistry {
    private List functions = new ArrayList();
    private Map sortedFunctions = new TreeMap();
    private DoubleKeyMap categorizedFunctions = new DoubleKeyMap();
    private DoubleKeyMap categorizedGeometryFunctions = new DoubleKeyMap();

    public static GeometryFunctionRegistry createTestBuilderRegistry() {
        GeometryFunctionRegistry geometryFunctionRegistry = new GeometryFunctionRegistry();
        geometryFunctionRegistry.add(GeometryFunctions.class);
        geometryFunctionRegistry.add(BufferFunctions.class);
        geometryFunctionRegistry.add(BufferByUnionFunctions.class);
        geometryFunctionRegistry.add(ConstructionFunctions.class);
        geometryFunctionRegistry.add(ConversionFunctions.class);
        geometryFunctionRegistry.add(LinearReferencingFunctions.class);
        geometryFunctionRegistry.add(LineHandlingFunctions.class);
        geometryFunctionRegistry.add(NodingFunctions.class);
        geometryFunctionRegistry.add(PolygonizeFunctions.class);
        geometryFunctionRegistry.add(PolygonOverlayFunctions.class);
        geometryFunctionRegistry.add(PrecisionFunctions.class);
        geometryFunctionRegistry.add(PreparedGeometryFunctions.class);
        geometryFunctionRegistry.add(SelectionFunctions.class);
        geometryFunctionRegistry.add(SimplificationFunctions.class);
        geometryFunctionRegistry.add(AffineTransformationFunctions.class);
        geometryFunctionRegistry.add(DistanceFunctions.class);
        geometryFunctionRegistry.add(CreateShapeFunctions.class);
        geometryFunctionRegistry.add(CreateFractalShapeFunctions.class);
        geometryFunctionRegistry.add(CreateRandomShapeFunctions.class);
        geometryFunctionRegistry.add(JTSFunctions.class);
        geometryFunctionRegistry.add(OffsetCurveFunctions.class);
        geometryFunctionRegistry.add(CGAlgorithmFunctions.class);
        geometryFunctionRegistry.add(OverlayFunctions.class);
        geometryFunctionRegistry.add(OverlayNoSnapFunctions.class);
        geometryFunctionRegistry.add(SnappingFunctions.class);
        geometryFunctionRegistry.add(SortingFunctions.class);
        geometryFunctionRegistry.add(TriangulationFunctions.class);
        geometryFunctionRegistry.add(TriangleFunctions.class);
        geometryFunctionRegistry.add(ValidationFunctions.class);
        return geometryFunctionRegistry;
    }

    public GeometryFunctionRegistry() {
    }

    public GeometryFunctionRegistry(Class clazz) {
        this.add(clazz);
    }

    public List getFunctions() {
        return this.functions;
    }

    public List getGeometryFunctions() {
        ArrayList<GeometryFunction> arrayList = new ArrayList<GeometryFunction>();
        for (GeometryFunction geometryFunction : this.sortedFunctions.values()) {
            if (!GeometryFunctionRegistry.hasGeometryResult(geometryFunction)) continue;
            arrayList.add(geometryFunction);
        }
        return arrayList;
    }

    public static boolean hasGeometryResult(GeometryFunction geometryFunction) {
        return Geometry.class.isAssignableFrom(geometryFunction.getReturnType());
    }

    public List getScalarFunctions() {
        ArrayList<GeometryFunction> arrayList = new ArrayList<GeometryFunction>();
        for (GeometryFunction geometryFunction : this.sortedFunctions.values()) {
            if (GeometryFunctionRegistry.hasGeometryResult(geometryFunction)) continue;
            arrayList.add(geometryFunction);
        }
        return arrayList;
    }

    public void add(Class clazz) {
        List list = this.createFunctions(clazz);
        Collections.sort(list);
        this.add(list);
    }

    public void add(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.getClass().getClassLoader().loadClass(string);
        this.add(clazz);
    }

    public void add(Collection collection) {
        for (GeometryFunction geometryFunction : collection) {
            this.add(geometryFunction);
        }
    }

    public List createFunctions(Class clazz) {
        ArrayList<StaticMethodGeometryFunction> arrayList = new ArrayList<StaticMethodGeometryFunction>();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n = methodArray[i].getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
            arrayList.add(StaticMethodGeometryFunction.createFunction(methodArray[i]));
        }
        return arrayList;
    }

    public void add(GeometryFunction geometryFunction) {
        this.functions.add(geometryFunction);
        this.sortedFunctions.put(geometryFunction.getName(), geometryFunction);
        this.categorizedFunctions.put(geometryFunction.getCategory(), geometryFunction.getName(), geometryFunction);
        if (GeometryFunctionRegistry.hasGeometryResult(geometryFunction)) {
            this.categorizedGeometryFunctions.put(geometryFunction.getCategory(), geometryFunction.getName(), geometryFunction);
        }
    }

    public DoubleKeyMap getCategorizedGeometryFunctions() {
        return this.categorizedGeometryFunctions;
    }

    public Collection getCategories() {
        return this.categorizedFunctions.keySet();
    }

    public Collection getFunctions(String string) {
        return this.categorizedFunctions.values(string);
    }

    public GeometryFunction find(String string, Class[] classArray) {
        return null;
    }

    public GeometryFunction find(String string, int n) {
        for (GeometryFunction geometryFunction : this.functions) {
            String string2 = geometryFunction.getName();
            if (!string2.equalsIgnoreCase(string) || geometryFunction.getParameterTypes().length != n) continue;
            return geometryFunction;
        }
        return null;
    }

    public GeometryFunction find(String string) {
        for (GeometryFunction geometryFunction : this.functions) {
            String string2 = geometryFunction.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return geometryFunction;
        }
        return null;
    }
}

