/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.shape.random.RandomPointsBuilder;
import com.vividsolutions.jts.shape.random.RandomPointsInGridBuilder;
import com.vividsolutions.jtstest.function.FunctionsUtil;
import java.util.ArrayList;

public class CreateRandomShapeFunctions {
    public static Geometry randomPointsInGrid(Geometry geometry, int n) {
        RandomPointsInGridBuilder randomPointsInGridBuilder = new RandomPointsInGridBuilder(FunctionsUtil.getFactoryOrDefault(geometry));
        randomPointsInGridBuilder.setExtent(FunctionsUtil.getEnvelopeOrDefault(geometry));
        randomPointsInGridBuilder.setNumPoints(n);
        return randomPointsInGridBuilder.getGeometry();
    }

    public static Geometry randomPointsInGridCircles(Geometry geometry, int n) {
        RandomPointsInGridBuilder randomPointsInGridBuilder = new RandomPointsInGridBuilder(FunctionsUtil.getFactoryOrDefault(geometry));
        randomPointsInGridBuilder.setExtent(FunctionsUtil.getEnvelopeOrDefault(geometry));
        randomPointsInGridBuilder.setNumPoints(n);
        randomPointsInGridBuilder.setConstrainedToCircle(true);
        return randomPointsInGridBuilder.getGeometry();
    }

    public static Geometry randomPointsInGridWithGutter(Geometry geometry, int n, double d) {
        RandomPointsInGridBuilder randomPointsInGridBuilder = new RandomPointsInGridBuilder(FunctionsUtil.getFactoryOrDefault(geometry));
        randomPointsInGridBuilder.setExtent(FunctionsUtil.getEnvelopeOrDefault(geometry));
        randomPointsInGridBuilder.setNumPoints(n);
        randomPointsInGridBuilder.setGutterFraction(d);
        return randomPointsInGridBuilder.getGeometry();
    }

    public static Geometry randomPoints(Geometry geometry, int n) {
        RandomPointsBuilder randomPointsBuilder = new RandomPointsBuilder(FunctionsUtil.getFactoryOrDefault(geometry));
        randomPointsBuilder.setExtent(FunctionsUtil.getEnvelopeOrDefault(geometry));
        randomPointsBuilder.setNumPoints(n);
        return randomPointsBuilder.getGeometry();
    }

    public static Geometry randomPointsInPolygon(Geometry geometry, int n) {
        RandomPointsBuilder randomPointsBuilder = new RandomPointsBuilder(FunctionsUtil.getFactoryOrDefault(geometry));
        randomPointsBuilder.setExtent(geometry);
        randomPointsBuilder.setNumPoints(n);
        return randomPointsBuilder.getGeometry();
    }

    public static Geometry randomPointsInTriangle(Geometry geometry, int n) {
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        Coordinate[] coordinateArray = geometry.getCoordinates();
        Coordinate coordinate = coordinateArray[0];
        Coordinate coordinate2 = coordinateArray[1];
        Coordinate coordinate3 = coordinateArray[2];
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(geometryFactory.createPoint(CreateRandomShapeFunctions.randomPointInTriangle(coordinate, coordinate2, coordinate3)));
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    private static Coordinate randomPointInTriangle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d;
        double d2 = Math.random();
        if (d2 + (d = Math.random()) > 1.0) {
            d2 = 1.0 - d2;
            d = 1.0 - d;
        }
        double d3 = 1.0 - (d2 + d);
        double d4 = d2;
        double d5 = d;
        double d6 = d3 * coordinate.x + d4 * coordinate2.x + d5 * coordinate3.x;
        double d7 = d3 * coordinate.y + d4 * coordinate2.y + d5 * coordinate3.y;
        return new Coordinate(d6, d7);
    }

    public static Geometry randomRadialPoints(Geometry geometry, int n) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        double d = envelope.getWidth();
        double d2 = envelope.getHeight();
        double d3 = Math.min(d, d2) / 2.0;
        double d4 = envelope.getMinX() + d / 2.0;
        double d5 = envelope.getMinY() + d2 / 2.0;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < n; ++i) {
            double d6 = Math.random();
            double d7 = d3 * d6 * d6;
            double d8 = Math.PI * 2 * Math.random();
            double d9 = d4 + d7 * Math.cos(d8);
            double d10 = d5 + d7 * Math.sin(d8);
            arrayList.add(geometryFactory.createPoint(new Coordinate(d9, d10)));
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    public static Geometry haltonPoints(Geometry geometry, int n) {
        return CreateRandomShapeFunctions.haltonPointsWithBases(geometry, n, 2, 3);
    }

    public static Geometry haltonPoints57(Geometry geometry, int n) {
        return CreateRandomShapeFunctions.haltonPointsWithBases(geometry, n, 5, 7);
    }

    public static Geometry haltonPointsWithBases(Geometry geometry, int n, int n2, int n3) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        Coordinate[] coordinateArray = new Coordinate[n];
        double d = envelope.getMinX();
        double d2 = envelope.getMinY();
        int n4 = 0;
        while (n4 < n) {
            double d3;
            double d4 = d + envelope.getWidth() * CreateRandomShapeFunctions.haltonOrdinate(n4 + 1, n2);
            Coordinate coordinate = new Coordinate(d4, d3 = d2 + envelope.getHeight() * CreateRandomShapeFunctions.haltonOrdinate(n4 + 1, n3));
            if (!envelope.contains(coordinate)) continue;
            coordinateArray[n4++] = coordinate;
        }
        return FunctionsUtil.getFactoryOrDefault(geometry).createMultiPoint(coordinateArray);
    }

    private static double haltonOrdinate(int n, int n2) {
        double d = 0.0;
        double d2 = 1.0 / (double)n2;
        int n3 = n;
        while (n3 > 0) {
            d += d2 * (double)(n3 % n2);
            n3 = (int)Math.floor((double)n3 / (double)n2);
            d2 /= (double)n2;
        }
        return d;
    }

    public static Geometry randomSegments(Geometry geometry, int n) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        double d = envelope.getWidth();
        double d2 = envelope.getHeight();
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        for (int i = 0; i < n; ++i) {
            double d3 = envelope.getMinX() + d * Math.random();
            double d4 = envelope.getMinY() + d2 * Math.random();
            double d5 = envelope.getMinX() + d * Math.random();
            double d6 = envelope.getMinY() + d2 * Math.random();
            arrayList.add(geometryFactory.createLineString(new Coordinate[]{new Coordinate(d3, d4), new Coordinate(d5, d6)}));
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    public static Geometry randomSegmentsInGrid(Geometry geometry, int n) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        int n2 = (int)Math.sqrt(n) + 1;
        double d = envelope.getWidth() / (double)n2;
        double d2 = envelope.getHeight() / (double)n2;
        ArrayList<LineString> arrayList = new ArrayList<LineString>();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d3 = envelope.getMinX() + (double)i * d + d * Math.random();
                double d4 = envelope.getMinY() + (double)j * d2 + d2 * Math.random();
                double d5 = envelope.getMinX() + (double)i * d + d * Math.random();
                double d6 = envelope.getMinY() + (double)j * d2 + d2 * Math.random();
                arrayList.add(geometryFactory.createLineString(new Coordinate[]{new Coordinate(d3, d4), new Coordinate(d5, d6)}));
            }
        }
        return geometryFactory.buildGeometry(arrayList);
    }

    public static Geometry randomLineString(Geometry geometry, int n) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        double d = envelope.getWidth();
        double d2 = envelope.getHeight();
        Coordinate[] coordinateArray = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            double d3 = d * Math.random();
            double d4 = d2 * Math.random();
            coordinateArray[i] = CreateRandomShapeFunctions.randomPtInRectangleAround(envelope.centre(), d3, d4);
        }
        return geometryFactory.createLineString(coordinateArray);
    }

    public static Geometry randomRectilinearWalk(Geometry geometry, int n) {
        Envelope envelope = FunctionsUtil.getEnvelopeOrDefault(geometry);
        GeometryFactory geometryFactory = FunctionsUtil.getFactoryOrDefault(geometry);
        double d = envelope.getWidth();
        double d2 = envelope.getHeight();
        Coordinate[] coordinateArray = new Coordinate[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = null;
            if (i == 0) {
                coordinate = CreateRandomShapeFunctions.randomPtInRectangleAround(envelope.centre(), d, d2);
            } else {
                double d3 = d * (Math.random() - 0.5);
                double d4 = coordinateArray[i - 1].x;
                double d5 = coordinateArray[i - 1].y;
                if (bl) {
                    d4 += d3;
                } else {
                    d5 += d3;
                }
                bl = !bl;
                coordinate = new Coordinate(d4, d5);
            }
            coordinateArray[i] = coordinate;
        }
        return geometryFactory.createLineString(coordinateArray);
    }

    private static int randomQuadrant(int n) {
        int n2;
        do {
            if ((n2 = (int)(Math.random() * 4.0)) <= 3) continue;
            n2 = 3;
        } while (n2 == n);
        return n2;
    }

    private static Coordinate randomPtInRectangleAround(Coordinate coordinate, double d, double d2) {
        double d3 = coordinate.x + d * (Math.random() - 0.5);
        double d4 = coordinate.y + d2 * (Math.random() - 0.5);
        return new Coordinate(d3, d4);
    }
}

