/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.function;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.CGAlgorithmsDD;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;

public class CGAlgorithmFunctions {
    public static int orientationIndex(Geometry geometry, Geometry geometry2) {
        if (geometry.getNumPoints() != 2 || geometry2.getNumPoints() != 1) {
            throw new IllegalArgumentException("A must have two points and B must have one");
        }
        Coordinate[] coordinateArray = geometry.getCoordinates();
        Coordinate coordinate = geometry2.getCoordinate();
        int n = CGAlgorithms.orientationIndex((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinate);
        return n;
    }

    public static int orientationIndexDD(Geometry geometry, Geometry geometry2) {
        if (geometry.getNumPoints() != 2 || geometry2.getNumPoints() != 1) {
            throw new IllegalArgumentException("A must have two points and B must have one");
        }
        Coordinate[] coordinateArray = geometry.getCoordinates();
        Coordinate coordinate = geometry2.getCoordinate();
        int n = CGAlgorithmsDD.orientationIndex((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinate);
        return n;
    }

    public static boolean segmentIntersects(Geometry geometry, Geometry geometry2) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        Coordinate[] coordinateArray2 = geometry2.getCoordinates();
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        robustLineIntersector.computeIntersection(coordinateArray[0], coordinateArray[1], coordinateArray2[0], coordinateArray2[1]);
        return robustLineIntersector.hasIntersection();
    }

    public static Geometry segmentIntersection(Geometry geometry, Geometry geometry2) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        Coordinate[] coordinateArray2 = geometry2.getCoordinates();
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        robustLineIntersector.computeIntersection(coordinateArray[0], coordinateArray[1], coordinateArray2[0], coordinateArray2[1]);
        switch (robustLineIntersector.getIntersectionNum()) {
            case 0: {
                return geometry.getFactory().createPoint((Coordinate)null);
            }
            case 1: {
                return geometry.getFactory().createPoint(robustLineIntersector.getIntersection(0));
            }
            case 2: {
                return geometry.getFactory().createLineString(new Coordinate[]{robustLineIntersector.getIntersection(0), robustLineIntersector.getIntersection(1)});
            }
        }
        return null;
    }

    public static Geometry segmentIntersectionDD(Geometry geometry, Geometry geometry2) {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        Coordinate[] coordinateArray2 = geometry2.getCoordinates();
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        robustLineIntersector.computeIntersection(coordinateArray[0], coordinateArray[1], coordinateArray2[0], coordinateArray2[1]);
        if (!robustLineIntersector.hasIntersection()) {
            return geometry.getFactory().createPoint((Coordinate)null);
        }
        Coordinate coordinate = CGAlgorithmsDD.intersection((Coordinate)coordinateArray[0], (Coordinate)coordinateArray[1], (Coordinate)coordinateArray2[0], (Coordinate)coordinateArray2[1]);
        return geometry.getFactory().createPoint(coordinate);
    }
}

