/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testrunner;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jtstest.testrunner.BooleanResult;
import com.vividsolutions.jtstest.testrunner.ReportWriter;
import com.vividsolutions.jtstest.testrunner.Test;
import com.vividsolutions.jtstest.testrunner.TestCase;
import com.vividsolutions.jtstest.testrunner.TestEngine;
import com.vividsolutions.jtstest.testrunner.TestRun;
import com.vividsolutions.jtstest.util.StringUtil;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;

public class SimpleReportWriter
implements ReportWriter {
    private boolean verbose;
    private StringWriter reportBuf;

    public SimpleReportWriter(boolean bl) {
        this.verbose = bl;
    }

    public String writeReport(TestEngine testEngine) {
        this.reportBuf = new StringWriter();
        this.reportOnParsingProblems(testEngine.getParsingProblems());
        this.reportOnTestRuns(testEngine.getTestRuns());
        this.reportBuf.write("\n\n");
        this.reportSummary(testEngine);
        this.reportBuf.write("\n");
        this.reportOnTime(testEngine.getStart(), testEngine.getEnd());
        return this.reportBuf.toString();
    }

    public String write(Test test) {
        this.reportBuf = new StringWriter();
        this.reportOnTest(test);
        return this.reportBuf.toString();
    }

    public void reportOnTime(Date date, Date date2) {
        long l = date2.getTime() - date.getTime();
        long l2 = l / 86400000L;
        long l3 = (l - l2 * 24L * 60L * 60L * 1000L) / 3600000L;
        long l4 = (l - l3 * 60L * 60L * 1000L) / 60000L;
        double d = (double)(l - l4 * 60L * 1000L) / 1000.0;
        String string = "Elapsed time: ";
        string = string + (l2 > 0L ? l2 + " days, " : "");
        string = string + (l3 > 0L ? l3 + " hours, " : "");
        string = string + (l4 > 0L ? l4 + " minutes, " : "");
        string = string + (d > 0.0 ? d + " seconds" : "");
        this.reportBuf.write(string);
    }

    public void reportOnTest(Test test) {
        String string = test.getGeometryIndex() + " " + test.getOperation();
        for (int i = 0; i < test.getArgumentCount(); ++i) {
            string = string + " " + test.getArgument(i);
        }
        if (test.getExpectedResult() instanceof BooleanResult) {
            string = string + ", " + test.getExpectedResult().toShortString();
        }
        if (test.getDescription().length() > 0) {
            string = string + ", " + test.getDescription();
        }
        String string2 = "";
        if (test.getException() != null) {
            this.reportBuf.write("Test Threw Exception (" + string + ")" + "     " + (this.verbose ? StringUtil.getStackTrace(test.getException()) : test.getException().toString()) + "\n");
        } else if (test.isPassed() && this.verbose) {
            this.reportBuf.write("Test Passed (" + string + ")" + "\n");
        } else if (!test.isPassed()) {
            this.reportBuf.write("Test Failed (" + string + ")" + "\n");
            if (this.verbose) {
                this.reportBuf.write("  Expected: " + test.getExpectedResult().toFormattedString() + "\n");
                try {
                    this.reportBuf.write("  Actual: " + test.getActualResult().toFormattedString() + "\n");
                }
                catch (Exception exception) {
                    Assert.shouldNeverReachHere((String)exception.toString());
                }
            }
        }
    }

    private void reportOnParsingProblems(List list) {
        if (list.isEmpty()) {
            return;
        }
        this.reportBuf.write("\n");
        for (String string : list) {
            this.reportBuf.write(string);
            this.reportBuf.write("\n");
        }
    }

    private void reportOnTestRuns(List list) {
        for (TestRun testRun : list) {
            this.reportOnTestRun(testRun);
        }
    }

    private void reportOnTestRun(TestRun testRun) {
        this.reportOnTestCases(testRun.getTestCases());
    }

    private void reportOnTestCases(List list) {
        for (TestCase testCase : list) {
            if (!testCase.isRun()) continue;
            this.reportOnTestCase(testCase);
        }
    }

    private boolean areAllTestsPassed(TestCase testCase) {
        for (Test test : testCase.getTests()) {
            if (test.isPassed()) continue;
            return false;
        }
        return true;
    }

    private void reportOnTestCase(TestCase testCase) {
        if (this.areAllTestsPassed(testCase) && !this.verbose) {
            return;
        }
        this.reportBuf.write("\n");
        this.reportBuf.write("Case " + testCase.getTestRun().getTestFile().getName() + " - #" + testCase.getCaseIndex() + " (" + testCase.getLineNumber() + ")" + (testCase.getDescription().length() > 0 ? ": " + testCase.getDescription() : "") + "\n");
        this.reportOnTests(testCase.getTests());
    }

    private void reportOnTests(List list) {
        for (Test test : list) {
            this.reportOnTest(test);
        }
    }

    public void reportSummary(TestEngine testEngine) {
        if (testEngine.getParseExceptionCount() > 0) {
            this.reportBuf.write(testEngine.getParseExceptionCount() + " parsing exceptions\n");
        }
        this.reportBuf.write(testEngine.getTestCaseCount() + " cases with " + testEngine.getTestCount() + " tests" + "  --  ");
        this.reportBuf.write(testEngine.getPassedCount() + " passed, " + testEngine.getFailedCount() + " failed, " + testEngine.getExceptionCount() + " threw exceptions");
        if (testEngine.getParseExceptionCount() + testEngine.getFailedCount() + testEngine.getExceptionCount() > 0) {
            this.reportBuf.write("\n\n*******  ERRORS ENCOUNTERED IN RUN  ********\n");
        }
    }
}

