/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtstest.testbuilder.ui.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jtstest.testbuilder.ui.tools.IndicatorTool;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LineBandTool
extends IndicatorTool {
    private List coordinates = new ArrayList();
    protected Coordinate tentativeCoordinate;
    private boolean closeRing = false;
    private int clickCountToFinish = 2;
    private boolean drawBandLines = true;

    protected void setCloseRing(boolean bl) {
        this.closeRing = bl;
    }

    protected void setClickCountToFinishGesture(int n) {
        this.clickCountToFinish = n;
    }

    protected void setDrawBandLines(boolean bl) {
        this.drawBandLines = bl;
    }

    public List getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public Coordinate lastCoordinate() {
        if (this.coordinates.size() <= 0) {
            return null;
        }
        return (Coordinate)this.coordinates.get(this.coordinates.size() - 1);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 1) {
                this.tentativeCoordinate = this.toModelSnapped(mouseEvent.getPoint());
                this.redrawIndicator();
            }
            super.mouseReleased(mouseEvent);
            if (this.isFinishingRelease(mouseEvent)) {
                this.finishGesture();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void mouseLocationChanged(MouseEvent mouseEvent) {
        try {
            this.tentativeCoordinate = this.toModelSnapped(mouseEvent.getPoint());
            this.redrawIndicator();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this.mouseLocationChanged(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.mouseLocationChanged(mouseEvent);
    }

    protected void add(Coordinate coordinate) {
        if (this.coordinates.size() > 0 && coordinate.equals2D((Coordinate)this.coordinates.get(this.coordinates.size() - 1))) {
            return;
        }
        this.coordinates.add(coordinate);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            super.mousePressed(mouseEvent);
            if (mouseEvent.getClickCount() != 1) {
                return;
            }
            this.add(this.toModelSnapped(mouseEvent.getPoint()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Shape getShape() {
        if (this.coordinates.isEmpty()) {
            return null;
        }
        Point2D point2D = this.toView((Coordinate)this.coordinates.get(0));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        if (!this.drawBandLines) {
            return generalPath;
        }
        for (int i = 1; i < this.coordinates.size(); ++i) {
            Coordinate coordinate = (Coordinate)this.coordinates.get(i);
            Point2D point2D2 = this.toView(coordinate);
            generalPath.lineTo((int)point2D2.getX(), (int)point2D2.getY());
        }
        Point2D point2D3 = this.toView(this.tentativeCoordinate);
        generalPath.lineTo((int)point2D3.getX(), (int)point2D3.getY());
        if (this.closeRing) {
            generalPath.lineTo((int)point2D.getX(), (int)point2D.getY());
        }
        return generalPath;
    }

    protected boolean isFinishingRelease(MouseEvent mouseEvent) {
        return mouseEvent.getClickCount() == this.clickCountToFinish;
    }

    protected Coordinate[] toArray(List list) {
        return list.toArray(new Coordinate[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishGesture() throws Exception {
        this.clearIndicator();
        try {
            this.bandFinished();
        }
        finally {
            this.coordinates.clear();
        }
    }

    protected abstract void bandFinished() throws Exception;
}

